/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.job;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.state.ESuccess;
import com.helger.base.timing.StopWatch;
import com.helger.quartz.IJob;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobExecutionException;
import com.helger.schedule.job.IJobExceptionCallback;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedCounter;
import com.helger.statistics.api.IMutableStatisticsHandlerKeyedTimer;
import com.helger.statistics.impl.StatisticsManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractJob
implements IJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJob.class);
    private static final IMutableStatisticsHandlerKeyedTimer STATS_TIMER = StatisticsManager.getKeyedTimerHandler(AbstractJob.class);
    private static final IMutableStatisticsHandlerKeyedCounter STATS_COUNTER_SUCCESS = StatisticsManager.getKeyedCounterHandler((String)(String.valueOf(AbstractJob.class) + "$success"));
    private static final IMutableStatisticsHandlerKeyedCounter STATS_COUNTER_FAILURE = StatisticsManager.getKeyedCounterHandler((String)(String.valueOf(AbstractJob.class) + "$failure"));
    private static final CallbackList<IJobExceptionCallback> EXCEPTION_CALLBACKS = new CallbackList();

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IJobExceptionCallback> exceptionCallbacks() {
        return EXCEPTION_CALLBACKS;
    }

    @OverrideOnDemand
    protected void beforeExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) {
    }

    @OverrideOnDemand
    protected abstract void onExecute(@Nonnull JobDataMap var1, @Nonnull IJobExecutionContext var2) throws JobExecutionException;

    @OverrideOnDemand
    protected void afterExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext, @Nonnull ESuccess eSuccess) {
    }

    protected static void triggerCustomExceptionHandler(@Nonnull Throwable throwable, @Nullable String string, @Nonnull IJob iJob) {
        AbstractJob.exceptionCallbacks().forEach(iJobExceptionCallback -> iJobExceptionCallback.onScheduledJobException(throwable, string, iJob));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(@Nonnull IJobExecutionContext iJobExecutionContext) throws JobExecutionException {
        ESuccess eSuccess = ESuccess.FAILURE;
        JobDataMap jobDataMap = new JobDataMap((Map)iJobExecutionContext.getMergedJobDataMap());
        this.beforeExecute(jobDataMap, iJobExecutionContext);
        try {
            String string = this.getClass().getName();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Executing scheduled job " + string);
                }
                StopWatch stopWatch = StopWatch.createdStarted();
                this.onExecute(jobDataMap, iJobExecutionContext);
                eSuccess = ESuccess.SUCCESS;
                STATS_TIMER.addTime(string, stopWatch.stopAndGetMillis());
                STATS_COUNTER_SUCCESS.increment(string);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Successfully finished executing scheduled job " + string);
                }
            }
            catch (Exception exception) {
                STATS_COUNTER_FAILURE.increment(string);
                AbstractJob.triggerCustomExceptionHandler(exception, string, this);
                if (exception instanceof JobExecutionException) {
                    throw (JobExecutionException)exception;
                }
                throw new JobExecutionException("Internal job execution error of " + string, (Throwable)exception);
            }
        }
        finally {
            this.afterExecute(jobDataMap, iJobExecutionContext, eSuccess);
        }
    }
}

