/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.utils.counter;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.quartz.utils.counter.CounterConfig;
import com.helger.quartz.utils.counter.ICounter;
import com.helger.quartz.utils.counter.ICounterManager;
import com.helger.quartz.utils.counter.sampled.ISampledCounter;
import com.helger.quartz.utils.counter.sampled.SampledCounter;
import jakarta.annotation.Nonnull;
import java.util.Timer;

public class CounterManager
implements ICounterManager {
    private final Timer m_aTimer;
    private boolean m_bShutdown;
    private final ICommonsList<ICounter> m_aCounters = new CommonsArrayList();

    public CounterManager(@Nonnull Timer timer) {
        ValueEnforcer.notNull((Object)timer, (String)"Timer");
        this.m_aTimer = timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown(boolean bl) {
        if (!this.m_bShutdown) {
            try {
                for (ICounter iCounter : this.m_aCounters) {
                    if (!(iCounter instanceof ISampledCounter)) continue;
                    ISampledCounter iSampledCounter = (ISampledCounter)iCounter;
                    iSampledCounter.shutdown();
                }
                if (bl) {
                    this.m_aTimer.cancel();
                }
            }
            finally {
                this.m_bShutdown = true;
            }
        }
    }

    @Override
    public synchronized ICounter createCounter(CounterConfig counterConfig) {
        ValueEnforcer.notNull((Object)counterConfig, (String)"Config");
        ValueEnforcer.isFalse((boolean)this.m_bShutdown, (String)"counter manager is shutdown");
        ICounter iCounter = counterConfig.createCounter();
        if (iCounter instanceof SampledCounter) {
            SampledCounter sampledCounter = (SampledCounter)iCounter;
            this.m_aTimer.schedule(sampledCounter.getTimerTask(), sampledCounter.getIntervalMillis(), sampledCounter.getIntervalMillis());
        }
        this.m_aCounters.add((Object)iCounter);
        return iCounter;
    }

    @Override
    public void shutdownCounter(ICounter iCounter) {
        if (iCounter instanceof ISampledCounter) {
            ISampledCounter iSampledCounter = (ISampledCounter)iCounter;
            iSampledCounter.shutdown();
        }
    }
}

