/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.utils;

import com.helger.annotation.concurrent.Immutable;
import com.helger.collection.commons.CommonsArrayList;
import java.lang.annotation.Annotation;

@Immutable
public final class ClassUtils {
    private ClassUtils() {
    }

    private static boolean _isAnnotationPresentOnInterfacesRecursive(Class<?> clazz, Class<? extends Annotation> clazz2) {
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            if (clazz3.isAnnotationPresent(clazz2)) {
                return true;
            }
            if (!ClassUtils._isAnnotationPresentOnInterfacesRecursive(clazz3, clazz2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> clazz2) {
        for (Class<?> clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (clazz3.isAnnotationPresent(clazz2)) {
                return true;
            }
            if (!ClassUtils._isAnnotationPresentOnInterfacesRecursive(clazz3, clazz2)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> clazz2) {
        Object object;
        Class clazz3;
        for (clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            object = clazz3.getAnnotation(clazz2);
            if (object == null) continue;
            return object;
        }
        object = new CommonsArrayList();
        object.add(clazz);
        while (!object.isEmpty()) {
            clazz3 = (Class)object.removeFirstOrNull();
            if (clazz3 == null) continue;
            if (clazz3.isInterface()) {
                T t = clazz3.getAnnotation(clazz2);
                if (t != null) {
                    return t;
                }
            } else {
                object.add(clazz3.getSuperclass());
            }
            object.addAll((Object[])clazz3.getInterfaces());
        }
        return null;
    }
}

