/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.simpl;

import com.helger.quartz.IJob;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.IScheduler;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.spi.IJobFactory;
import com.helger.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJobFactory
implements IJobFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleJobFactory.class);

    @Override
    public IJob newJob(TriggerFiredBundle triggerFiredBundle, IScheduler iScheduler) throws SchedulerException {
        IJobDetail iJobDetail = triggerFiredBundle.getJobDetail();
        Class<? extends IJob> clazz = iJobDetail.getJobClass();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Producing instance of Job '" + String.valueOf(iJobDetail.getKey()) + "', class=" + clazz.getName());
            }
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new SchedulerException("Problem instantiating class '" + iJobDetail.getJobClass().getName() + "'", exception);
        }
    }
}

