/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.plugins.history;

import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IMatcher;
import com.helger.quartz.IScheduler;
import com.helger.quartz.ITrigger;
import com.helger.quartz.ITriggerListener;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.impl.matchers.EverythingMatcher;
import com.helger.quartz.spi.IClassLoadHelper;
import com.helger.quartz.spi.ISchedulerPlugin;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingTriggerHistoryPlugin
implements ISchedulerPlugin,
ITriggerListener {
    private String m_sName;
    private String m_sTriggerFiredMessage = "Trigger {1}.{0} fired job {6}.{5} at: {4, date, HH:mm:ss MM/dd/yyyy}";
    private String m_sTriggerMisfiredMessage = "Trigger {1}.{0} misfired job {6}.{5}  at: {4, date, HH:mm:ss MM/dd/yyyy}.  Should have fired at: {3, date, HH:mm:ss MM/dd/yyyy}";
    private String m_sTriggerCompleteMessage = "Trigger {1}.{0} completed firing job {6}.{5} at {4, date, HH:mm:ss MM/dd/yyyy} with resulting trigger instruction code: {9}";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingTriggerHistoryPlugin.class);

    public String getTriggerCompleteMessage() {
        return this.m_sTriggerCompleteMessage;
    }

    public String getTriggerFiredMessage() {
        return this.m_sTriggerFiredMessage;
    }

    public String getTriggerMisfiredMessage() {
        return this.m_sTriggerMisfiredMessage;
    }

    public void setTriggerCompleteMessage(String string) {
        this.m_sTriggerCompleteMessage = string;
    }

    public void setTriggerFiredMessage(String string) {
        this.m_sTriggerFiredMessage = string;
    }

    public void setTriggerMisfiredMessage(String string) {
        this.m_sTriggerMisfiredMessage = string;
    }

    @Override
    public void initialize(String string, IScheduler iScheduler, IClassLoadHelper iClassLoadHelper) throws SchedulerException {
        this.m_sName = string;
        iScheduler.getListenerManager().addTriggerListener((ITriggerListener)this, (IMatcher<TriggerKey>)EverythingMatcher.allTriggers());
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public void triggerFired(ITrigger iTrigger, IJobExecutionContext iJobExecutionContext) {
        Object[] objectArray = new Object[]{iTrigger.getKey().getName(), iTrigger.getKey().getGroup(), iTrigger.getPreviousFireTime(), iTrigger.getNextFireTime(), new Date(), iJobExecutionContext.getJobDetail().getKey().getName(), iJobExecutionContext.getJobDetail().getKey().getGroup(), iJobExecutionContext.getRefireCount()};
        LOGGER.info(new MessageFormat(this.getTriggerFiredMessage(), Locale.US).format(objectArray));
    }

    @Override
    public void triggerMisfired(ITrigger iTrigger) {
        Object[] objectArray = new Object[]{iTrigger.getKey().getName(), iTrigger.getKey().getGroup(), iTrigger.getPreviousFireTime(), iTrigger.getNextFireTime(), new Date(), iTrigger.getJobKey().getName(), iTrigger.getJobKey().getGroup()};
        LOGGER.info(new MessageFormat(this.getTriggerMisfiredMessage(), Locale.US).format(objectArray));
    }

    @Override
    public void triggerComplete(ITrigger iTrigger, IJobExecutionContext iJobExecutionContext, ITrigger.ECompletedExecutionInstruction eCompletedExecutionInstruction) {
        String string = "UNKNOWN";
        if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.DELETE_TRIGGER) {
            string = "DELETE TRIGGER";
        } else if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.NOOP) {
            string = "DO NOTHING";
        } else if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.RE_EXECUTE_JOB) {
            string = "RE-EXECUTE JOB";
        } else if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
            string = "SET ALL OF JOB'S TRIGGERS COMPLETE";
        } else if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
            string = "SET THIS TRIGGER COMPLETE";
        }
        Object[] objectArray = new Object[]{iTrigger.getKey().getName(), iTrigger.getKey().getGroup(), iTrigger.getPreviousFireTime(), iTrigger.getNextFireTime(), new Date(), iJobExecutionContext.getJobDetail().getKey().getName(), iJobExecutionContext.getJobDetail().getKey().getGroup(), iJobExecutionContext.getRefireCount(), eCompletedExecutionInstruction.toString(), string};
        LOGGER.info(new MessageFormat(this.getTriggerCompleteMessage(), Locale.US).format(objectArray));
    }

    @Override
    public boolean vetoJobExecution(ITrigger iTrigger, IJobExecutionContext iJobExecutionContext) {
        return false;
    }
}

