/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.triggers;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.datetime.helper.PDTFactory;
import com.helger.quartz.CQuartz;
import com.helger.quartz.ICalendar;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.ISimpleTrigger;
import com.helger.quartz.ITrigger;
import com.helger.quartz.QCloneUtils;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.SimpleScheduleBuilder;
import com.helger.quartz.impl.triggers.AbstractTrigger;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Calendar;
import java.util.Date;

public class SimpleTrigger
extends AbstractTrigger<SimpleTrigger>
implements ISimpleTrigger {
    private Date m_aStartTime;
    private Date m_aEndTime;
    private Date m_aNextFireTime;
    private Date m_aPreviousFireTime;
    private int m_nRepeatCount = 0;
    private long m_nRepeatInterval = 0L;
    private int m_nTimesTriggered = 0;

    public SimpleTrigger(@Nonnull SimpleTrigger simpleTrigger) {
        super(simpleTrigger);
        this.m_aStartTime = QCloneUtils.getClone(simpleTrigger.m_aStartTime);
        this.m_aEndTime = QCloneUtils.getClone(simpleTrigger.m_aEndTime);
        this.m_aNextFireTime = QCloneUtils.getClone(simpleTrigger.m_aNextFireTime);
        this.m_aPreviousFireTime = QCloneUtils.getClone(simpleTrigger.m_aPreviousFireTime);
        this.m_nRepeatCount = simpleTrigger.m_nRepeatCount;
        this.m_nRepeatInterval = simpleTrigger.m_nRepeatInterval;
        this.m_nTimesTriggered = simpleTrigger.m_nTimesTriggered;
    }

    public SimpleTrigger() {
    }

    @Override
    @Nullable
    public final Date getStartTime() {
        return this.m_aStartTime;
    }

    @Override
    public void setStartTime(@Nonnull Date date) {
        ValueEnforcer.notNull((Object)date, (String)"StartTime");
        Date date2 = this.getEndTime();
        if (date2 != null && date2.before(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.m_aStartTime = date;
    }

    @Override
    @Nullable
    public final Date getEndTime() {
        return this.m_aEndTime;
    }

    @Override
    public final void setEndTime(@Nullable Date date) {
        Date date2 = this.getStartTime();
        if (date2 != null && date != null && date2.after(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.m_aEndTime = date;
    }

    @Override
    public int getRepeatCount() {
        return this.m_nRepeatCount;
    }

    public void setRepeatCount(int n) {
        if (n < 0 && n != -1) {
            throw new IllegalArgumentException("Repeat count must be >= 0, use the constant REPEAT_INDEFINITELY for infinite.");
        }
        this.m_nRepeatCount = n;
    }

    @Override
    public long getRepeatInterval() {
        return this.m_nRepeatInterval;
    }

    public void setRepeatInterval(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Repeat interval must be >= 0");
        }
        this.m_nRepeatInterval = l;
    }

    @Override
    public int getTimesTriggered() {
        return this.m_nTimesTriggered;
    }

    public void setTimesTriggered(int n) {
        this.m_nTimesTriggered = n;
    }

    @Override
    protected boolean validateMisfireInstruction(ITrigger.EMisfireInstruction eMisfireInstruction) {
        switch (eMisfireInstruction) {
            case MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY: 
            case MISFIRE_INSTRUCTION_SMART_POLICY: 
            case MISFIRE_INSTRUCTION_FIRE_ONCE_NOW: 
            case MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT: 
            case MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT: 
            case MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_REMAINING_COUNT: 
            case MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_EXISTING_COUNT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateAfterMisfire(ICalendar iCalendar) {
        ITrigger.EMisfireInstruction eMisfireInstruction = this.getMisfireInstruction();
        if (eMisfireInstruction == ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_SMART_POLICY) {
            eMisfireInstruction = this.getRepeatCount() == 0 ? ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_FIRE_ONCE_NOW : (this.getRepeatCount() == -1 ? ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_REMAINING_COUNT : ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT);
        } else if (eMisfireInstruction == ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_FIRE_ONCE_NOW && this.getRepeatCount() != 0) {
            eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT;
        }
        switch (eMisfireInstruction) {
            case MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY: {
                return;
            }
            case MISFIRE_INSTRUCTION_FIRE_ONCE_NOW: {
                this.setNextFireTime(new Date());
                break;
            }
            case MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_EXISTING_COUNT: {
                Date date = this.getFireTimeAfter(new Date());
                while (date != null && iCalendar != null && !iCalendar.isTimeIncluded(date.getTime()) && (date = this.getFireTimeAfter(date)) != null) {
                    Calendar calendar = PDTFactory.createCalendar();
                    calendar.setTime(date);
                    if (calendar.get(1) <= CQuartz.MAX_YEAR) continue;
                    date = null;
                }
                this.setNextFireTime(date);
                break;
            }
            case MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_REMAINING_COUNT: {
                Date date = this.getFireTimeAfter(new Date());
                while (date != null && iCalendar != null && !iCalendar.isTimeIncluded(date.getTime()) && (date = this.getFireTimeAfter(date)) != null) {
                    Calendar calendar = PDTFactory.createCalendar();
                    calendar.setTime(date);
                    if (calendar.get(1) <= CQuartz.MAX_YEAR) continue;
                    date = null;
                }
                if (date != null) {
                    int n = this.computeNumTimesFiredBetween(this.m_aNextFireTime, date);
                    this.setTimesTriggered(this.getTimesTriggered() + n);
                }
                this.setNextFireTime(date);
                break;
            }
            case MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT: {
                Date date = new Date();
                if (this.m_nRepeatCount != 0 && this.m_nRepeatCount != -1) {
                    this.setRepeatCount(this.getRepeatCount() - this.getTimesTriggered());
                    this.setTimesTriggered(0);
                }
                if (this.getEndTime() != null && this.getEndTime().before(date)) {
                    this.setNextFireTime(null);
                    break;
                }
                this.setStartTime(date);
                this.setNextFireTime(date);
                break;
            }
            case MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT: {
                Date date = new Date();
                int n = this.computeNumTimesFiredBetween(this.m_aNextFireTime, date);
                if (this.m_nRepeatCount != 0 && this.m_nRepeatCount != -1) {
                    int n2 = this.getRepeatCount() - (this.getTimesTriggered() + n);
                    if (n2 <= 0) {
                        n2 = 0;
                    }
                    this.setRepeatCount(n2);
                    this.setTimesTriggered(0);
                }
                if (this.getEndTime() != null && this.getEndTime().before(date)) {
                    this.setNextFireTime(null);
                    break;
                }
                this.setStartTime(date);
                this.setNextFireTime(date);
                break;
            }
        }
    }

    @Override
    public void triggered(ICalendar iCalendar) {
        ++this.m_nTimesTriggered;
        this.m_aPreviousFireTime = this.m_aNextFireTime;
        this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
        while (this.m_aNextFireTime != null && iCalendar != null && !iCalendar.isTimeIncluded(this.m_aNextFireTime.getTime())) {
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
            if (this.m_aNextFireTime == null) break;
            Calendar calendar = PDTFactory.createCalendar();
            calendar.setTime(this.m_aNextFireTime);
            if (calendar.get(1) <= CQuartz.MAX_YEAR) continue;
            this.m_aNextFireTime = null;
        }
    }

    @Override
    public void updateWithNewCalendar(ICalendar iCalendar, long l) {
        this.m_aNextFireTime = this.getFireTimeAfter(this.m_aPreviousFireTime);
        if (this.m_aNextFireTime == null || iCalendar == null) {
            return;
        }
        Date date = new Date();
        while (this.m_aNextFireTime != null && !iCalendar.isTimeIncluded(this.m_aNextFireTime.getTime())) {
            long l2;
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
            if (this.m_aNextFireTime == null) break;
            Calendar calendar = PDTFactory.createCalendar();
            calendar.setTime(this.m_aNextFireTime);
            if (calendar.get(1) > CQuartz.MAX_YEAR) {
                this.m_aNextFireTime = null;
            }
            if (this.m_aNextFireTime == null || !this.m_aNextFireTime.before(date) || (l2 = date.getTime() - this.m_aNextFireTime.getTime()) < l) continue;
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
        }
    }

    @Override
    public Date computeFirstFireTime(ICalendar iCalendar) {
        this.m_aNextFireTime = this.getStartTime();
        while (this.m_aNextFireTime != null && iCalendar != null && !iCalendar.isTimeIncluded(this.m_aNextFireTime.getTime())) {
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
            if (this.m_aNextFireTime == null) break;
            Calendar calendar = PDTFactory.createCalendar();
            calendar.setTime(this.m_aNextFireTime);
            if (calendar.get(1) <= CQuartz.MAX_YEAR) continue;
            return null;
        }
        return this.m_aNextFireTime;
    }

    @Override
    public Date getNextFireTime() {
        return this.m_aNextFireTime;
    }

    @Override
    public Date getPreviousFireTime() {
        return this.m_aPreviousFireTime;
    }

    @Override
    public void setNextFireTime(Date date) {
        this.m_aNextFireTime = date;
    }

    @Override
    public void setPreviousFireTime(Date date) {
        this.m_aPreviousFireTime = date;
    }

    @Override
    public Date getFireTimeAfter(@Nullable Date date) {
        long l;
        if (this.m_nTimesTriggered > this.m_nRepeatCount && this.m_nRepeatCount != -1) {
            return null;
        }
        Date date2 = date;
        if (date2 == null) {
            date2 = new Date();
        }
        if (this.m_nRepeatCount == 0 && date2.compareTo(this.getStartTime()) >= 0) {
            return null;
        }
        long l2 = this.getStartTime().getTime();
        long l3 = date2.getTime();
        long l4 = l = this.getEndTime() == null ? Long.MAX_VALUE : this.getEndTime().getTime();
        if (l <= l3) {
            return null;
        }
        if (l3 < l2) {
            return new Date(l2);
        }
        long l5 = (l3 - l2) / this.m_nRepeatInterval + 1L;
        if (l5 > (long)this.m_nRepeatCount && this.m_nRepeatCount != -1) {
            return null;
        }
        Date date3 = new Date(l2 + l5 * this.m_nRepeatInterval);
        if (l <= date3.getTime()) {
            return null;
        }
        return date3;
    }

    public Date getFireTimeBefore(Date date) {
        if (date.getTime() < this.getStartTime().getTime()) {
            return null;
        }
        int n = this.computeNumTimesFiredBetween(this.getStartTime(), date);
        return new Date(this.getStartTime().getTime() + (long)n * this.m_nRepeatInterval);
    }

    public int computeNumTimesFiredBetween(Date date, Date date2) {
        if (this.m_nRepeatInterval < 1L) {
            return 0;
        }
        long l = date2.getTime() - date.getTime();
        return (int)(l / this.m_nRepeatInterval);
    }

    @Override
    public Date getFinalFireTime() {
        if (this.m_nRepeatCount == 0) {
            return this.m_aStartTime;
        }
        if (this.m_nRepeatCount == -1) {
            return this.getEndTime() == null ? null : this.getFireTimeBefore(this.getEndTime());
        }
        long l = this.m_aStartTime.getTime() + (long)this.m_nRepeatCount * this.m_nRepeatInterval;
        if (this.getEndTime() == null || l < this.getEndTime().getTime()) {
            return new Date(l);
        }
        return this.getFireTimeBefore(this.getEndTime());
    }

    @Override
    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    @Override
    public void validate() throws SchedulerException {
        super.validate();
        if (this.m_nRepeatCount != 0 && this.m_nRepeatInterval < 1L) {
            throw new SchedulerException("Repeat Interval cannot be zero.");
        }
    }

    @Override
    public IScheduleBuilder<SimpleTrigger> getScheduleBuilder() {
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(this.getRepeatInterval()).withRepeatCount(this.getRepeatCount());
        switch (this.getMisfireInstruction()) {
            case MISFIRE_INSTRUCTION_FIRE_ONCE_NOW: {
                simpleScheduleBuilder.withMisfireHandlingInstructionFireNow();
                break;
            }
            case MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_EXISTING_COUNT: {
                simpleScheduleBuilder.withMisfireHandlingInstructionNextWithExistingCount();
                break;
            }
            case MISFIRE_INSTRUCTION_RESCHEDULE_NEXT_WITH_REMAINING_COUNT: {
                simpleScheduleBuilder.withMisfireHandlingInstructionNextWithRemainingCount();
                break;
            }
            case MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_EXISTING_REPEAT_COUNT: {
                simpleScheduleBuilder.withMisfireHandlingInstructionNowWithExistingCount();
                break;
            }
            case MISFIRE_INSTRUCTION_RESCHEDULE_NOW_WITH_REMAINING_REPEAT_COUNT: {
                simpleScheduleBuilder.withMisfireHandlingInstructionNowWithRemainingCount();
            }
        }
        return simpleScheduleBuilder;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public SimpleTrigger getClone() {
        return new SimpleTrigger(this);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Nonnull
    public static SimpleTrigger create(@Nonnull String string, @Nullable String string2, @Nonnull String string3, @Nullable String string4, Date date, Date date2, int n, long l) {
        SimpleTrigger simpleTrigger = new SimpleTrigger();
        simpleTrigger.setName(string);
        simpleTrigger.setGroup(string2);
        simpleTrigger.setJobName(string3);
        simpleTrigger.setJobGroup(string4);
        simpleTrigger.setStartTime(date);
        simpleTrigger.setEndTime(date2);
        simpleTrigger.setRepeatCount(n);
        simpleTrigger.setRepeatInterval(l);
        return simpleTrigger;
    }
}

