/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.matchers;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.quartz.IMatcher;
import com.helger.quartz.utils.Key;
import jakarta.annotation.Nonnull;

public abstract class StringMatcher<T extends Key<T>>
implements IMatcher<T> {
    private final String m_sCompareTo;
    private final EStringOperatorName m_eCompareWith;

    protected StringMatcher(@Nonnull String string, @Nonnull EStringOperatorName eStringOperatorName) {
        ValueEnforcer.notNull((Object)string, (String)"CompareTo");
        ValueEnforcer.notNull((Object)((Object)eStringOperatorName), (String)"CompareWith");
        this.m_sCompareTo = string;
        this.m_eCompareWith = eStringOperatorName;
    }

    @Nonnull
    public final String getCompareToValue() {
        return this.m_sCompareTo;
    }

    @Nonnull
    public final EStringOperatorName getCompareWithOperator() {
        return this.m_eCompareWith;
    }

    @Nonnull
    protected abstract String getValue(T var1);

    @Override
    public final boolean isMatch(T t) {
        return this.m_eCompareWith.evaluate(this.getValue(t), this.m_sCompareTo);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        StringMatcher stringMatcher = (StringMatcher)object;
        return this.m_sCompareTo.equals(stringMatcher.m_sCompareTo) && this.m_eCompareWith.equals((Object)stringMatcher.m_eCompareWith);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sCompareTo).append((Object)this.m_eCompareWith).getHashCode();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum EStringOperatorName {
        EQUALS{

            @Override
            public boolean evaluate(@Nonnull String string, @Nonnull String string2) {
                return string.equals(string2);
            }
        }
        ,
        STARTS_WITH{

            @Override
            public boolean evaluate(@Nonnull String string, @Nonnull String string2) {
                return string.startsWith(string2);
            }
        }
        ,
        ENDS_WITH{

            @Override
            public boolean evaluate(@Nonnull String string, @Nonnull String string2) {
                return string.endsWith(string2);
            }
        }
        ,
        CONTAINS{

            @Override
            public boolean evaluate(@Nonnull String string, @Nonnull String string2) {
                return string.contains(string2);
            }
        }
        ,
        ANYTHING{

            @Override
            public boolean evaluate(@Nonnull String string, @Nonnull String string2) {
                return true;
            }
        };


        public abstract boolean evaluate(@Nonnull String var1, @Nonnull String var2);
    }
}

