/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz;

import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsSet;
import com.helger.quartz.ICalendar;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IListenerManager;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobKey;
import com.helger.quartz.SchedulerContext;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.SchedulerMetaData;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.UnableToInterruptJobException;
import com.helger.quartz.impl.matchers.GroupMatcher;
import com.helger.quartz.spi.IJobFactory;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface IScheduler {
    public static final String DEFAULT_GROUP = "DEFAULT";
    public static final String DEFAULT_RECOVERY_GROUP = "RECOVERING_JOBS";
    public static final String DEFAULT_FAIL_OVER_GROUP = "FAILED_OVER_JOBS";
    public static final String FAILED_JOB_ORIGINAL_TRIGGER_NAME = "QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME";
    public static final String FAILED_JOB_ORIGINAL_TRIGGER_GROUP = "QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP";
    public static final String FAILED_JOB_ORIGINAL_TRIGGER_FIRETIME_IN_MILLISECONDS = "QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING";
    public static final String FAILED_JOB_ORIGINAL_TRIGGER_SCHEDULED_FIRETIME_IN_MILLISECONDS = "QRTZ_FAILED_JOB_ORIG_TRIGGER_SCHEDULED_FIRETIME_IN_MILLISECONDS_AS_STRING";

    public String getSchedulerName() throws SchedulerException;

    public String getSchedulerInstanceId() throws SchedulerException;

    public SchedulerContext getContext() throws SchedulerException;

    public void start() throws SchedulerException;

    public void startDelayed(int var1) throws SchedulerException;

    public boolean isStarted() throws SchedulerException;

    public void standby() throws SchedulerException;

    public boolean isInStandbyMode() throws SchedulerException;

    public void shutdown() throws SchedulerException;

    public void shutdown(boolean var1) throws SchedulerException;

    public boolean isShutdown() throws SchedulerException;

    public SchedulerMetaData getMetaData() throws SchedulerException;

    public ICommonsList<IJobExecutionContext> getCurrentlyExecutingJobs() throws SchedulerException;

    public void setJobFactory(IJobFactory var1) throws SchedulerException;

    public IListenerManager getListenerManager() throws SchedulerException;

    public Date scheduleJob(IJobDetail var1, ITrigger var2) throws SchedulerException;

    public Date scheduleJob(ITrigger var1) throws SchedulerException;

    public void scheduleJobs(Map<IJobDetail, Set<? extends ITrigger>> var1, boolean var2) throws SchedulerException;

    public void scheduleJob(IJobDetail var1, Set<? extends ITrigger> var2, boolean var3) throws SchedulerException;

    public boolean unscheduleJob(TriggerKey var1) throws SchedulerException;

    public boolean unscheduleJobs(List<TriggerKey> var1) throws SchedulerException;

    public Date rescheduleJob(TriggerKey var1, ITrigger var2) throws SchedulerException;

    public void addJob(IJobDetail var1, boolean var2) throws SchedulerException;

    public void addJob(IJobDetail var1, boolean var2, boolean var3) throws SchedulerException;

    public boolean deleteJob(JobKey var1) throws SchedulerException;

    public boolean deleteJobs(List<JobKey> var1) throws SchedulerException;

    public void triggerJob(JobKey var1) throws SchedulerException;

    public void triggerJob(JobKey var1, JobDataMap var2) throws SchedulerException;

    public void pauseJob(JobKey var1) throws SchedulerException;

    public void pauseJobs(GroupMatcher<JobKey> var1) throws SchedulerException;

    public void pauseTrigger(TriggerKey var1) throws SchedulerException;

    public void pauseTriggers(GroupMatcher<TriggerKey> var1) throws SchedulerException;

    public void resumeJob(JobKey var1) throws SchedulerException;

    public void resumeJobs(GroupMatcher<JobKey> var1) throws SchedulerException;

    public void resumeTrigger(TriggerKey var1) throws SchedulerException;

    public void resumeTriggers(GroupMatcher<TriggerKey> var1) throws SchedulerException;

    public void pauseAll() throws SchedulerException;

    public void resumeAll() throws SchedulerException;

    public ICommonsList<String> getJobGroupNames() throws SchedulerException;

    public ICommonsSet<JobKey> getJobKeys(GroupMatcher<JobKey> var1) throws SchedulerException;

    public ICommonsList<? extends ITrigger> getTriggersOfJob(JobKey var1) throws SchedulerException;

    public ICommonsList<String> getTriggerGroupNames() throws SchedulerException;

    public ICommonsSet<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> var1) throws SchedulerException;

    public ICommonsSet<String> getPausedTriggerGroups() throws SchedulerException;

    public IJobDetail getJobDetail(JobKey var1) throws SchedulerException;

    public ITrigger getTrigger(TriggerKey var1) throws SchedulerException;

    public ITrigger.ETriggerState getTriggerState(TriggerKey var1) throws SchedulerException;

    public void addCalendar(String var1, ICalendar var2, boolean var3, boolean var4) throws SchedulerException;

    public boolean deleteCalendar(String var1) throws SchedulerException;

    public ICalendar getCalendar(String var1) throws SchedulerException;

    public ICommonsList<String> getCalendarNames() throws SchedulerException;

    public boolean interrupt(JobKey var1) throws UnableToInterruptJobException;

    public boolean interrupt(String var1) throws UnableToInterruptJobException;

    public boolean checkExists(JobKey var1) throws SchedulerException;

    public boolean checkExists(TriggerKey var1) throws SchedulerException;

    public void clear() throws SchedulerException;
}

