/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.quartz.CQuartz;
import com.helger.quartz.QCloneUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;

public final class CronExpression
implements ICloneable<CronExpression> {
    private static final int ALL_SPEC_INT = 99;
    private static final int NO_SPEC_INT = 98;
    private static final Integer ALL_SPEC = 99;
    private static final Integer NO_SPEC = 98;
    private static final ICommonsMap<String, Integer> MONTH_MAP = new CommonsHashMap(12);
    private static final ICommonsMap<String, Integer> DAY_OF_WEEK_MAP = new CommonsHashMap(7);
    private final String m_sCronExpression;
    private TimeZone m_aTimeZone;
    private TreeSet<Integer> m_aSeconds;
    private TreeSet<Integer> m_aMinutes;
    private TreeSet<Integer> m_aHours;
    private TreeSet<Integer> m_aDaysOfMonth;
    private TreeSet<Integer> m_aMonths;
    private TreeSet<Integer> m_aDaysOfWeek;
    private TreeSet<Integer> m_aYears;
    private boolean m_bLastdayOfWeek = false;
    private int m_nNthdayOfWeek = 0;
    private boolean m_bLastdayOfMonth = false;
    private boolean m_bNearestWeekday = false;
    private int m_nLastdayOffset = 0;

    public CronExpression(@Nonnull String string) throws ParseException {
        ValueEnforcer.notNull((Object)string, (String)"CronExpression");
        this.m_sCronExpression = string.toUpperCase(Locale.US);
        this._buildExpression(this.m_sCronExpression);
    }

    public CronExpression(CronExpression cronExpression) {
        this.m_sCronExpression = cronExpression.getCronExpression();
        try {
            this._buildExpression(this.m_sCronExpression);
        }
        catch (ParseException parseException) {
            throw new AssertionError();
        }
        this.setTimeZone(QCloneUtils.getClone(cronExpression.getTimeZone()));
    }

    public boolean isSatisfiedBy(Date date) {
        Calendar calendar = Calendar.getInstance(this.getTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
        calendar.setTime(date);
        calendar.set(14, 0);
        Date date2 = calendar.getTime();
        calendar.add(13, -1);
        Date date3 = this.getTimeAfter(calendar.getTime());
        return date3 != null && date3.equals(date2);
    }

    public Date getNextValidTimeAfter(Date date) {
        return this.getTimeAfter(date);
    }

    public Date getNextInvalidTimeAfter(Date date) {
        Date date2;
        long l = 1000L;
        Calendar calendar = Calendar.getInstance(this.getTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
        calendar.setTime(date);
        calendar.set(14, 0);
        Date date3 = calendar.getTime();
        while (l == 1000L && (date2 = this.getTimeAfter(date3)) != null) {
            l = date2.getTime() - date3.getTime();
            if (l != 1000L) continue;
            date3 = date2;
        }
        return new Date(date3.getTime() + 1000L);
    }

    @Nonnull
    public TimeZone getTimeZone() {
        if (this.m_aTimeZone == null) {
            this.m_aTimeZone = TimeZone.getDefault();
        }
        return this.m_aTimeZone;
    }

    public void setTimeZone(@Nullable TimeZone timeZone) {
        this.m_aTimeZone = timeZone;
    }

    public String toString() {
        return this.m_sCronExpression;
    }

    public static boolean isValidExpression(String string) {
        try {
            CronExpression.validateExpression(string);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static void validateExpression(String string) throws ParseException {
        new CronExpression(string);
    }

    private void _buildExpression(String string) throws ParseException {
        try {
            boolean bl;
            if (this.m_aSeconds == null) {
                this.m_aSeconds = new TreeSet();
            }
            if (this.m_aMinutes == null) {
                this.m_aMinutes = new TreeSet();
            }
            if (this.m_aHours == null) {
                this.m_aHours = new TreeSet();
            }
            if (this.m_aDaysOfMonth == null) {
                this.m_aDaysOfMonth = new TreeSet();
            }
            if (this.m_aMonths == null) {
                this.m_aMonths = new TreeSet();
            }
            if (this.m_aDaysOfWeek == null) {
                this.m_aDaysOfWeek = new TreeSet();
            }
            if (this.m_aYears == null) {
                this.m_aYears = new TreeSet();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t", false);
            Enum enum_ = null;
            for (EType eType : EType.values()) {
                if (!stringTokenizer.hasMoreTokens()) break;
                String string2 = stringTokenizer.nextToken().trim();
                if (eType == EType.DAY_OF_MONTH && string2.indexOf(76) != -1 && string2.length() > 1 && string2.indexOf(44) >= 0) {
                    throw new ParseException("Support for specifying 'L' and 'LW' with other days of the month is not implemented", -1);
                }
                if (eType == EType.DAY_OF_WEEK) {
                    if (string2.indexOf(76) >= 0 && string2.length() > 1 && string2.indexOf(44) >= 0) {
                        throw new ParseException("Support for specifying 'L' with other days of the week is not implemented", -1);
                    }
                    if (string2.indexOf(35) >= 0 && string2.indexOf(35, string2.indexOf(35) + 1) != -1) {
                        throw new ParseException("Support for specifying multiple \"nth\" days is not implemented.", -1);
                    }
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    this._storeExpressionVals(0, string3, eType);
                }
                enum_ = eType;
            }
            if (enum_.ordinal() < EType.DAY_OF_WEEK.ordinal()) {
                throw new ParseException("Unexpected end of expression.", string.length());
            }
            if (enum_.ordinal() < EType.YEAR.ordinal()) {
                this._storeExpressionVals(0, "*", EType.YEAR);
            }
            TreeSet<Integer> treeSet = this.getSet(EType.DAY_OF_WEEK);
            TreeSet<Integer> treeSet2 = this.getSet(EType.DAY_OF_MONTH);
            int n = !treeSet2.contains(NO_SPEC) ? 1 : 0;
            boolean bl2 = bl = !treeSet.contains(NO_SPEC);
            if (n != 0 && bl) {
                throw new ParseException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.", 0);
            }
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            throw new ParseException("Illegal cron expression format (" + exception.toString() + ")", 0);
        }
    }

    private int _storeExpressionVals(int n, String string, EType eType) throws ParseException {
        int n2 = CronExpression._skipWhiteSpace(n, string);
        if (n2 >= string.length()) {
            return n2;
        }
        int n3 = 0;
        char c = string.charAt(n2);
        if (!(c < 'A' || c > 'Z' || string.equals("L") || string.equals("LW") || RegExHelper.stringMatchesPattern((String)"^L-[0-9]*[W]?", (String)string))) {
            int n4;
            int n5;
            block47: {
                String string2 = string.substring(n2, n2 + 3);
                n5 = -1;
                n4 = -1;
                if (eType == EType.MONTH) {
                    n5 = CronExpression._getMonthNumber(string2) + 1;
                    if (n5 <= 0) {
                        throw new ParseException("Invalid Month value: '" + string2 + "'", n2);
                    }
                    if (string.length() > n2 + 3 && (c = string.charAt(n2 + 3)) == '-' && (n4 = CronExpression._getMonthNumber(string2 = string.substring(n2 += 4, n2 + 3)) + 1) <= 0) {
                        throw new ParseException("Invalid Month value: '" + string2 + "'", n2);
                    }
                } else if (eType == EType.DAY_OF_WEEK) {
                    n5 = CronExpression._getDayOfWeekNumber(string2);
                    if (n5 < 0) {
                        throw new ParseException("Invalid Day-of-Week value: '" + string2 + "'", n2);
                    }
                    if (string.length() > n2 + 3) {
                        c = string.charAt(n2 + 3);
                        if (c == '-') {
                            if ((n4 = CronExpression._getDayOfWeekNumber(string2 = string.substring(n2 += 4, n2 + 3))) < 0) {
                                throw new ParseException("Invalid Day-of-Week value: '" + string2 + "'", n2);
                            }
                        } else {
                            if (c == '#') {
                                try {
                                    this.m_nNthdayOfWeek = Integer.parseInt(string.substring(n2 += 4));
                                    if (this.m_nNthdayOfWeek < 1 || this.m_nNthdayOfWeek > 5) {
                                        throw new Exception();
                                    }
                                    break block47;
                                }
                                catch (Exception exception) {
                                    throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", n2);
                                }
                            }
                            if (c == 'L') {
                                this.m_bLastdayOfWeek = true;
                                ++n2;
                            }
                        }
                    }
                } else {
                    throw new ParseException("Illegal characters for this position: '" + string2 + "'", n2);
                }
            }
            if (n4 != -1) {
                n3 = 1;
            }
            this._addToSet(n5, n4, n3, eType);
            return n2 + 3;
        }
        if (c == '?') {
            int n6;
            if (++n2 + 1 < string.length() && string.charAt(n2) != ' ' && string.charAt(n2 + 1) != '\t') {
                throw new ParseException("Illegal character after '?': " + string.charAt(n2), n2);
            }
            if (eType != EType.DAY_OF_WEEK && eType != EType.DAY_OF_MONTH) {
                throw new ParseException("'?' can only be specfied for Day-of-Month or Day-of-Week.", n2);
            }
            if (eType == EType.DAY_OF_WEEK && !this.m_bLastdayOfMonth && (n6 = this.m_aDaysOfMonth.last().intValue()) == 98) {
                throw new ParseException("'?' can only be specfied for Day-of-Month -OR- Day-of-Week.", n2);
            }
            this._addToSet(98, -1, 0, eType);
            return n2;
        }
        if (c == '*' || c == '/') {
            if (c == '*' && n2 + 1 >= string.length()) {
                this._addToSet(99, -1, n3, eType);
                return n2 + 1;
            }
            if (c == '/' && (n2 + 1 >= string.length() || string.charAt(n2 + 1) == ' ' || string.charAt(n2 + 1) == '\t')) {
                throw new ParseException("'/' must be followed by an integer.", n2);
            }
            if (c == '*') {
                ++n2;
            }
            if ((c = string.charAt(n2)) == '/') {
                if (++n2 >= string.length()) {
                    throw new ParseException("Unexpected end of string.", n2);
                }
                n3 = CronExpression._getNumericValue(string, n2);
                ++n2;
                if (n3 > 10) {
                    ++n2;
                }
                if (n3 > 59 && (eType == EType.SECOND || eType == EType.MINUTE)) {
                    throw new ParseException("Increment > 60 : " + n3, n2);
                }
                if (n3 > 23 && eType == EType.HOUR) {
                    throw new ParseException("Increment > 24 : " + n3, n2);
                }
                if (n3 > 31 && eType == EType.DAY_OF_MONTH) {
                    throw new ParseException("Increment > 31 : " + n3, n2);
                }
                if (n3 > 7 && eType == EType.DAY_OF_WEEK) {
                    throw new ParseException("Increment > 7 : " + n3, n2);
                }
                if (n3 > 12 && eType == EType.MONTH) {
                    throw new ParseException("Increment > 12 : " + n3, n2);
                }
            } else {
                n3 = 1;
            }
            this._addToSet(99, -1, n3, eType);
            return n2;
        }
        if (c == 'L') {
            ++n2;
            if (eType == EType.DAY_OF_MONTH) {
                this.m_bLastdayOfMonth = true;
            }
            if (eType == EType.DAY_OF_WEEK) {
                this._addToSet(7, 7, 0, eType);
            }
            if (eType == EType.DAY_OF_MONTH && string.length() > n2) {
                c = string.charAt(n2);
                if (c == '-') {
                    ValueSet valueSet = CronExpression._getValue(0, string, n2 + 1);
                    this.m_nLastdayOffset = valueSet.m_nValue;
                    if (this.m_nLastdayOffset > 30) {
                        throw new ParseException("Offset from last day must be <= 30", n2 + 1);
                    }
                    n2 = valueSet.m_nPos;
                }
                if (string.length() > n2 && (c = string.charAt(n2)) == 'W') {
                    this.m_bNearestWeekday = true;
                    ++n2;
                }
            }
            return n2;
        }
        if (c >= '0' && c <= '9') {
            int n7 = Integer.parseInt(String.valueOf(c));
            if (++n2 >= string.length()) {
                this._addToSet(n7, -1, -1, eType);
            } else {
                c = string.charAt(n2);
                if (c >= '0' && c <= '9') {
                    ValueSet valueSet = CronExpression._getValue(n7, string, n2);
                    n7 = valueSet.m_nValue;
                    n2 = valueSet.m_nPos;
                }
                n2 = this._checkNext(n2, string, n7, eType);
            }
            return n2;
        }
        throw new ParseException("Unexpected character: " + c, n2);
    }

    private int _checkNext(int n, String string, int n2, EType eType) throws ParseException {
        int n3 = -1;
        int n4 = n;
        if (n4 >= string.length()) {
            this._addToSet(n2, n3, -1, eType);
            return n4;
        }
        char c = string.charAt(n);
        if (c == 'L') {
            if (eType == EType.DAY_OF_WEEK) {
                if (n2 < 1 || n2 > 7) {
                    throw new ParseException("Day-of-Week values must be between 1 and 7", -1);
                }
            } else {
                throw new ParseException("'L' option is not valid here. (pos=" + n4 + ")", n4);
            }
            this.m_bLastdayOfWeek = true;
            TreeSet<Integer> treeSet = this.getSet(eType);
            treeSet.add(n2);
            return ++n4;
        }
        if (c == 'W') {
            if (eType != EType.DAY_OF_MONTH) {
                throw new ParseException("'W' option is not valid here. (pos=" + n4 + ")", n4);
            }
            this.m_bNearestWeekday = true;
            if (n2 > 31) {
                throw new ParseException("The 'W' option does not make sense with values larger than 31 (max number of days in a month)", n4);
            }
            TreeSet<Integer> treeSet = this.getSet(eType);
            treeSet.add(n2);
            return ++n4;
        }
        if (c == '#') {
            if (eType != EType.DAY_OF_WEEK) {
                throw new ParseException("'#' option is not valid here. (pos=" + n4 + ")", n4);
            }
            ++n4;
            try {
                this.m_nNthdayOfWeek = Integer.parseInt(string.substring(n4));
                if (this.m_nNthdayOfWeek < 1 || this.m_nNthdayOfWeek > 5) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", n4);
            }
            TreeSet<Integer> treeSet = this.getSet(eType);
            treeSet.add(n2);
            return ++n4;
        }
        if (c == '-') {
            int n5;
            c = string.charAt(++n4);
            n3 = n5 = Integer.parseInt(String.valueOf(c));
            if (++n4 >= string.length()) {
                this._addToSet(n2, n3, 1, eType);
                return n4;
            }
            c = string.charAt(n4);
            if (c >= '0' && c <= '9') {
                ValueSet valueSet = CronExpression._getValue(n5, string, n4);
                n3 = valueSet.m_nValue;
                n4 = valueSet.m_nPos;
            }
            if (n4 < string.length() && string.charAt(n4) == '/') {
                c = string.charAt(++n4);
                int n6 = Integer.parseInt(String.valueOf(c));
                if (++n4 >= string.length()) {
                    this._addToSet(n2, n3, n6, eType);
                    return n4;
                }
                c = string.charAt(n4);
                if (c >= '0' && c <= '9') {
                    ValueSet valueSet = CronExpression._getValue(n6, string, n4);
                    int n7 = valueSet.m_nValue;
                    this._addToSet(n2, n3, n7, eType);
                    n4 = valueSet.m_nPos;
                    return n4;
                }
                this._addToSet(n2, n3, n6, eType);
                return n4;
            }
            this._addToSet(n2, n3, 1, eType);
            return n4;
        }
        if (c == '/') {
            c = string.charAt(++n4);
            int n8 = Integer.parseInt(String.valueOf(c));
            if (++n4 >= string.length()) {
                this._addToSet(n2, n3, n8, eType);
                return n4;
            }
            c = string.charAt(n4);
            if (c >= '0' && c <= '9') {
                ValueSet valueSet = CronExpression._getValue(n8, string, n4);
                int n9 = valueSet.m_nValue;
                this._addToSet(n2, n3, n9, eType);
                n4 = valueSet.m_nPos;
                return n4;
            }
            throw new ParseException("Unexpected character '" + c + "' after '/'", n4);
        }
        this._addToSet(n2, n3, 0, eType);
        return ++n4;
    }

    public String getCronExpression() {
        return this.m_sCronExpression;
    }

    public String getExpressionSummary() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("seconds: ");
        stringBuilder.append(CronExpression._getExpressionSetSummary(this.m_aSeconds));
        stringBuilder.append("\n");
        stringBuilder.append("minutes: ");
        stringBuilder.append(CronExpression._getExpressionSetSummary(this.m_aMinutes));
        stringBuilder.append("\n");
        stringBuilder.append("hours: ");
        stringBuilder.append(CronExpression._getExpressionSetSummary(this.m_aHours));
        stringBuilder.append("\n");
        stringBuilder.append("daysOfMonth: ");
        stringBuilder.append(CronExpression._getExpressionSetSummary(this.m_aDaysOfMonth));
        stringBuilder.append("\n");
        stringBuilder.append("months: ");
        stringBuilder.append(CronExpression._getExpressionSetSummary(this.m_aMonths));
        stringBuilder.append("\n");
        stringBuilder.append("daysOfWeek: ");
        stringBuilder.append(CronExpression._getExpressionSetSummary(this.m_aDaysOfWeek));
        stringBuilder.append("\n");
        stringBuilder.append("lastdayOfWeek: ");
        stringBuilder.append(this.m_bLastdayOfWeek);
        stringBuilder.append("\n");
        stringBuilder.append("nearestWeekday: ");
        stringBuilder.append(this.m_bNearestWeekday);
        stringBuilder.append("\n");
        stringBuilder.append("NthDayOfWeek: ");
        stringBuilder.append(this.m_nNthdayOfWeek);
        stringBuilder.append("\n");
        stringBuilder.append("lastdayOfMonth: ");
        stringBuilder.append(this.m_bLastdayOfMonth);
        stringBuilder.append("\n");
        stringBuilder.append("years: ");
        stringBuilder.append(CronExpression._getExpressionSetSummary(this.m_aYears));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private static String _getExpressionSetSummary(Set<Integer> set) {
        if (set.contains(NO_SPEC)) {
            return "?";
        }
        if (set.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Integer> iterator = set.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Integer n = iterator.next();
            String string = n.toString();
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static int _skipWhiteSpace(int n, String string) {
        int n2;
        int n3 = string.length();
        for (n2 = n; n2 < n3 && Character.isWhitespace(string.charAt(n)); ++n2) {
        }
        return n2;
    }

    private static int _findNextWhiteSpace(int n, String string) {
        int n2;
        int n3 = string.length();
        for (n2 = n; n2 < n3 && !Character.isWhitespace(string.charAt(n)); ++n2) {
        }
        return n2;
    }

    private void _addToSet(int n, int n2, int n3, EType eType) throws ParseException {
        int n4 = n3;
        TreeSet<Integer> treeSet = this.getSet(eType);
        if (eType == EType.SECOND || eType == EType.MINUTE) {
            if ((n < 0 || n > 59 || n2 > 59) && n != 99) {
                throw new ParseException("Minute and Second values must be between 0 and 59", -1);
            }
        } else if (eType == EType.HOUR) {
            if ((n < 0 || n > 23 || n2 > 23) && n != 99) {
                throw new ParseException("Hour values must be between 0 and 23", -1);
            }
        } else if (eType == EType.DAY_OF_MONTH) {
            if ((n < 1 || n > 31 || n2 > 31) && n != 99 && n != 98) {
                throw new ParseException("Day of month values must be between 1 and 31", -1);
            }
        } else if (eType == EType.MONTH) {
            if ((n < 1 || n > 12 || n2 > 12) && n != 99) {
                throw new ParseException("Month values must be between 1 and 12", -1);
            }
        } else if (eType == EType.DAY_OF_WEEK && (n < 1 || n > 7 || n2 > 7) && n != 99 && n != 98) {
            throw new ParseException("Day-of-Week values must be between 1 and 7", -1);
        }
        if ((n4 == 0 || n4 == -1) && n != 99) {
            if (n != -1) {
                treeSet.add(n);
            } else {
                treeSet.add(NO_SPEC);
            }
            return;
        }
        int n5 = n;
        int n6 = n2;
        if (n == 99 && n4 <= 0) {
            n4 = 1;
            treeSet.add(ALL_SPEC);
        }
        if (eType == EType.SECOND || eType == EType.MINUTE) {
            if (n6 == -1) {
                n6 = 59;
            }
            if (n5 == -1 || n5 == 99) {
                n5 = 0;
            }
        } else if (eType == EType.HOUR) {
            if (n6 == -1) {
                n6 = 23;
            }
            if (n5 == -1 || n5 == 99) {
                n5 = 0;
            }
        } else if (eType == EType.DAY_OF_MONTH) {
            if (n6 == -1) {
                n6 = 31;
            }
            if (n5 == -1 || n5 == 99) {
                n5 = 1;
            }
        } else if (eType == EType.MONTH) {
            if (n6 == -1) {
                n6 = 12;
            }
            if (n5 == -1 || n5 == 99) {
                n5 = 1;
            }
        } else if (eType == EType.DAY_OF_WEEK) {
            if (n6 == -1) {
                n6 = 7;
            }
            if (n5 == -1 || n5 == 99) {
                n5 = 1;
            }
        } else if (eType == EType.YEAR) {
            if (n6 == -1) {
                n6 = CQuartz.MAX_YEAR;
            }
            if (n5 == -1 || n5 == 99) {
                n5 = 1970;
            }
        }
        int n7 = -1;
        if (n6 < n5) {
            switch (eType.ordinal()) {
                case 0: {
                    n7 = 60;
                    break;
                }
                case 1: {
                    n7 = 60;
                    break;
                }
                case 2: {
                    n7 = 24;
                    break;
                }
                case 4: {
                    n7 = 12;
                    break;
                }
                case 5: {
                    n7 = 7;
                    break;
                }
                case 3: {
                    n7 = 31;
                    break;
                }
                case 6: {
                    throw new IllegalArgumentException("Start year must be less than stop year");
                }
                default: {
                    throw new IllegalArgumentException("Unexpected type encountered");
                }
            }
            n6 += n7;
        }
        for (int i = n5; i <= n6; i += n4) {
            if (n7 == -1) {
                treeSet.add(i);
                continue;
            }
            int n8 = i % n7;
            if (n8 == 0 && (eType == EType.MONTH || eType == EType.DAY_OF_WEEK || eType == EType.DAY_OF_MONTH)) {
                n8 = n7;
            }
            treeSet.add(n8);
        }
    }

    @Nullable
    TreeSet<Integer> getSet(@Nonnull EType eType) {
        switch (eType.ordinal()) {
            case 0: {
                return this.m_aSeconds;
            }
            case 1: {
                return this.m_aMinutes;
            }
            case 2: {
                return this.m_aHours;
            }
            case 3: {
                return this.m_aDaysOfMonth;
            }
            case 4: {
                return this.m_aMonths;
            }
            case 5: {
                return this.m_aDaysOfWeek;
            }
            case 6: {
                return this.m_aYears;
            }
        }
        throw new IllegalStateException("oops");
    }

    @Nonnull
    private static ValueSet _getValue(int n, String string, int n2) {
        int n3 = n2;
        char c = string.charAt(n3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Integer.toString(n));
        while (c >= '0' && c <= '9') {
            stringBuilder.append(c);
            if (++n3 >= string.length()) break;
            c = string.charAt(n3);
        }
        return new ValueSet(Integer.parseInt(stringBuilder.toString()), n3 < string.length() ? n3 : n3 + 1);
    }

    private static int _getNumericValue(String string, int n) {
        int n2 = CronExpression._findNextWhiteSpace(n, string);
        String string2 = string.substring(n, n2);
        return Integer.parseInt(string2);
    }

    private static int _getMonthNumber(String string) {
        Integer n = (Integer)MONTH_MAP.get((Object)string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    private static int _getDayOfWeekNumber(String string) {
        Integer n = (Integer)DAY_OF_WEEK_MAP.get((Object)string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public Date getTimeAfter(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
        Date date2 = new Date(date.getTime() + 1000L);
        gregorianCalendar.setTime(date2);
        gregorianCalendar.set(14, 0);
        boolean bl = false;
        while (!bl) {
            boolean bl2;
            if (gregorianCalendar.get(1) > CQuartz.MAX_YEAR) {
                return null;
            }
            SortedSet<Integer> sortedSet = null;
            int n = 0;
            int n2 = gregorianCalendar.get(13);
            int n3 = gregorianCalendar.get(12);
            sortedSet = this.m_aSeconds.tailSet(n2);
            if (sortedSet != null && !sortedSet.isEmpty()) {
                n2 = sortedSet.first();
            } else {
                n2 = this.m_aSeconds.first();
                gregorianCalendar.set(12, ++n3);
            }
            gregorianCalendar.set(13, n2);
            n3 = gregorianCalendar.get(12);
            int n4 = gregorianCalendar.get(11);
            n = -1;
            sortedSet = this.m_aMinutes.tailSet(n3);
            if (sortedSet != null && !sortedSet.isEmpty()) {
                n = n3;
                n3 = sortedSet.first();
            } else {
                n3 = this.m_aMinutes.first();
                ++n4;
            }
            if (n3 != n) {
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(12, n3);
                CronExpression._setCalendarHour(gregorianCalendar, n4);
                continue;
            }
            gregorianCalendar.set(12, n3);
            n4 = gregorianCalendar.get(11);
            int n5 = gregorianCalendar.get(5);
            n = -1;
            sortedSet = this.m_aHours.tailSet(n4);
            if (sortedSet != null && !sortedSet.isEmpty()) {
                n = n4;
                n4 = sortedSet.first();
            } else {
                n4 = this.m_aHours.first();
                ++n5;
            }
            if (n4 != n) {
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(5, n5);
                CronExpression._setCalendarHour(gregorianCalendar, n4);
                continue;
            }
            gregorianCalendar.set(11, n4);
            n5 = gregorianCalendar.get(5);
            int n6 = gregorianCalendar.get(2) + 1;
            n = -1;
            int n7 = n6;
            boolean bl3 = !this.m_aDaysOfMonth.contains(NO_SPEC);
            boolean bl4 = bl2 = !this.m_aDaysOfWeek.contains(NO_SPEC);
            if (bl3 && !bl2) {
                sortedSet = this.m_aDaysOfMonth.tailSet(n5);
                if (this.m_bLastdayOfMonth) {
                    if (!this.m_bNearestWeekday) {
                        n = n5;
                        n5 = CronExpression._getLastDayOfMonth(n6, gregorianCalendar.get(1));
                        if (n > (n5 -= this.m_nLastdayOffset)) {
                            if (++n6 > 12) {
                                n6 = 1;
                                n7 = 3333;
                                ((Calendar)gregorianCalendar).add(1, 1);
                            }
                            n5 = 1;
                        }
                    } else {
                        n = n5;
                        n5 = CronExpression._getLastDayOfMonth(n6, gregorianCalendar.get(1));
                        Calendar calendar = Calendar.getInstance(this.getTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
                        calendar.set(13, 0);
                        calendar.set(12, 0);
                        calendar.set(11, 0);
                        calendar.set(5, n5 -= this.m_nLastdayOffset);
                        calendar.set(2, n6 - 1);
                        calendar.set(1, gregorianCalendar.get(1));
                        var16_22 = CronExpression._getLastDayOfMonth(n6, gregorianCalendar.get(1));
                        var17_23 = calendar.get(7);
                        if (var17_23 == 7 && n5 == 1) {
                            n5 += 2;
                        } else if (var17_23 == 7) {
                            --n5;
                        } else if (var17_23 == 1 && n5 == var16_22) {
                            n5 -= 2;
                        } else if (var17_23 == 1) {
                            ++n5;
                        }
                        calendar.set(13, n2);
                        calendar.set(12, n3);
                        calendar.set(11, n4);
                        calendar.set(5, n5);
                        calendar.set(2, n6 - 1);
                        Date date3 = calendar.getTime();
                        if (date3.before(date2)) {
                            n5 = 1;
                            ++n6;
                        }
                    }
                } else if (this.m_bNearestWeekday) {
                    n = n5;
                    n5 = this.m_aDaysOfMonth.first();
                    Calendar calendar = Calendar.getInstance(this.getTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
                    calendar.set(13, 0);
                    calendar.set(12, 0);
                    calendar.set(11, 0);
                    calendar.set(5, n5);
                    calendar.set(2, n6 - 1);
                    calendar.set(1, gregorianCalendar.get(1));
                    var16_22 = CronExpression._getLastDayOfMonth(n6, gregorianCalendar.get(1));
                    var17_23 = calendar.get(7);
                    if (var17_23 == 7 && n5 == 1) {
                        n5 += 2;
                    } else if (var17_23 == 7) {
                        --n5;
                    } else if (var17_23 == 1 && n5 == var16_22) {
                        n5 -= 2;
                    } else if (var17_23 == 1) {
                        ++n5;
                    }
                    calendar.set(13, n2);
                    calendar.set(12, n3);
                    calendar.set(11, n4);
                    calendar.set(5, n5);
                    calendar.set(2, n6 - 1);
                    Date date4 = calendar.getTime();
                    if (date4.before(date2)) {
                        n5 = this.m_aDaysOfMonth.first();
                        ++n6;
                    }
                } else if (sortedSet != null && !sortedSet.isEmpty()) {
                    int n8;
                    n = n5;
                    n5 = sortedSet.first();
                    if (n5 > (n8 = CronExpression._getLastDayOfMonth(n6, gregorianCalendar.get(1)))) {
                        n5 = this.m_aDaysOfMonth.first();
                        ++n6;
                    }
                } else {
                    n5 = this.m_aDaysOfMonth.first();
                    ++n6;
                }
                if (n5 != n || n6 != n7) {
                    gregorianCalendar.set(13, 0);
                    gregorianCalendar.set(12, 0);
                    gregorianCalendar.set(11, 0);
                    gregorianCalendar.set(5, n5);
                    gregorianCalendar.set(2, n6 - 1);
                    continue;
                }
            } else if (bl2 && !bl3) {
                if (this.m_bLastdayOfWeek) {
                    int n9;
                    int n10 = this.m_aDaysOfWeek.first();
                    var16_22 = gregorianCalendar.get(7);
                    var17_23 = 0;
                    if (var16_22 < n10) {
                        var17_23 = n10 - var16_22;
                    }
                    if (var16_22 > n10) {
                        var17_23 = n10 + (7 - var16_22);
                    }
                    if (n5 + var17_23 > (n9 = CronExpression._getLastDayOfMonth(n6, gregorianCalendar.get(1)))) {
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(2, n6);
                        continue;
                    }
                    while (n5 + var17_23 + 7 <= n9) {
                        var17_23 += 7;
                    }
                    n5 += var17_23;
                    if (var17_23 > 0) {
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(5, n5);
                        gregorianCalendar.set(2, n6 - 1);
                        continue;
                    }
                } else if (this.m_nNthdayOfWeek != 0) {
                    int n11 = this.m_aDaysOfWeek.first();
                    var16_22 = gregorianCalendar.get(7);
                    var17_23 = 0;
                    if (var16_22 < n11) {
                        var17_23 = n11 - var16_22;
                    } else if (var16_22 > n11) {
                        var17_23 = n11 + (7 - var16_22);
                    }
                    boolean bl5 = false;
                    if (var17_23 > 0) {
                        bl5 = true;
                    }
                    int n12 = (n5 += var17_23) / 7;
                    if (n5 % 7 > 0) {
                        ++n12;
                    }
                    if ((var17_23 = (this.m_nNthdayOfWeek - n12) * 7) < 0 || (n5 += var17_23) > CronExpression._getLastDayOfMonth(n6, gregorianCalendar.get(1))) {
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(2, n6);
                        continue;
                    }
                    if (var17_23 > 0 || bl5) {
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(5, n5);
                        gregorianCalendar.set(2, n6 - 1);
                        continue;
                    }
                } else {
                    int n13;
                    int n14 = gregorianCalendar.get(7);
                    var16_22 = this.m_aDaysOfWeek.first();
                    sortedSet = this.m_aDaysOfWeek.tailSet(n14);
                    if (sortedSet != null && !sortedSet.isEmpty()) {
                        var16_22 = sortedSet.first();
                    }
                    var17_23 = 0;
                    if (n14 < var16_22) {
                        var17_23 = var16_22 - n14;
                    }
                    if (n14 > var16_22) {
                        var17_23 = var16_22 + (7 - n14);
                    }
                    if (n5 + var17_23 > (n13 = CronExpression._getLastDayOfMonth(n6, gregorianCalendar.get(1)))) {
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(2, n6);
                        continue;
                    }
                    if (var17_23 > 0) {
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(5, n5 + var17_23);
                        gregorianCalendar.set(2, n6 - 1);
                        continue;
                    }
                }
            } else {
                throw new UnsupportedOperationException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.");
            }
            gregorianCalendar.set(5, n5);
            n6 = gregorianCalendar.get(2) + 1;
            int n15 = gregorianCalendar.get(1);
            n = -1;
            if (n15 > CQuartz.MAX_YEAR) {
                return null;
            }
            sortedSet = this.m_aMonths.tailSet(n6);
            if (sortedSet != null && !sortedSet.isEmpty()) {
                n = n6;
                n6 = sortedSet.first();
            } else {
                n6 = this.m_aMonths.first();
                ++n15;
            }
            if (n6 != n) {
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(5, 1);
                gregorianCalendar.set(2, n6 - 1);
                gregorianCalendar.set(1, n15);
                continue;
            }
            gregorianCalendar.set(2, n6 - 1);
            n15 = gregorianCalendar.get(1);
            sortedSet = this.m_aYears.tailSet(n15);
            if (sortedSet == null || sortedSet.isEmpty()) {
                return null;
            }
            n = n15;
            n15 = sortedSet.first();
            if (n15 != n) {
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(5, 1);
                gregorianCalendar.set(2, 0);
                gregorianCalendar.set(1, n15);
                continue;
            }
            gregorianCalendar.set(1, n15);
            bl = true;
        }
        return gregorianCalendar.getTime();
    }

    private static void _setCalendarHour(Calendar calendar, int n) {
        calendar.set(11, n);
        if (calendar.get(11) != n && n != 24) {
            calendar.set(11, n + 1);
        }
    }

    @Nullable
    public Date getTimeBefore(Date date) {
        return null;
    }

    @Nullable
    public Date getFinalFireTime() {
        return null;
    }

    private static boolean _isLeapYear(int n) {
        return n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
    }

    private static int _getLastDayOfMonth(int n, int n2) {
        switch (n) {
            case 1: {
                return 31;
            }
            case 2: {
                return CronExpression._isLeapYear(n2) ? 29 : 28;
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        throw new IllegalArgumentException("Illegal month number: " + n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this._buildExpression(this.m_sCronExpression);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public CronExpression getClone() {
        return new CronExpression(this);
    }

    static {
        for (Month enum_ : Month.values()) {
            MONTH_MAP.put((Object)enum_.getDisplayName(TextStyle.SHORT, Locale.US).toUpperCase(Locale.US), (Object)(enum_.getValue() - 1));
        }
        for (Enum enum_ : DayOfWeek.values()) {
            DAY_OF_WEEK_MAP.put((Object)((DayOfWeek)enum_).getDisplayName(TextStyle.SHORT, Locale.US).toUpperCase(Locale.US), (Object)((DayOfWeek)enum_).getValue());
        }
    }

    static enum EType {
        SECOND,
        MINUTE,
        HOUR,
        DAY_OF_MONTH,
        MONTH,
        DAY_OF_WEEK,
        YEAR;

    }

    private static final class ValueSet {
        final int m_nValue;
        final int m_nPos;

        public ValueSet(int n, int n2) {
            this.m_nValue = n;
            this.m_nPos = n2;
        }
    }
}

