/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.usergroup;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.string.StringHelper;
import com.helger.base.type.ObjectType;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.dao.DAOException;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.io.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.security.object.BusinessObjectHelper;
import com.helger.photon.security.object.StubObject;
import com.helger.photon.security.role.IRoleManager;
import com.helger.photon.security.user.IUserManager;
import com.helger.photon.security.usergroup.IUserGroup;
import com.helger.photon.security.usergroup.IUserGroupManager;
import com.helger.photon.security.usergroup.IUserGroupModificationCallback;
import com.helger.photon.security.usergroup.UserGroup;
import com.helger.tenancy.IBusinessObject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

@ThreadSafe
public class UserGroupManager
extends AbstractPhotonMapBasedWALDAO<IUserGroup, UserGroup>
implements IUserGroupManager {
    private final IUserManager m_aUserMgr;
    private final IRoleManager m_aRoleMgr;
    private final CallbackList<IUserGroupModificationCallback> m_aCallbacks = new CallbackList();

    public UserGroupManager(@Nonnull @Nonempty String string, @Nonnull IUserManager iUserManager, @Nonnull IRoleManager iRoleManager) throws DAOException {
        super(UserGroup.class, string);
        this.m_aUserMgr = (IUserManager)ValueEnforcer.notNull((Object)iUserManager, (String)"UserManager");
        this.m_aRoleMgr = (IRoleManager)ValueEnforcer.notNull((Object)iRoleManager, (String)"RoleManager");
    }

    @Override
    @Nonnull
    public final IUserManager getUserManager() {
        return this.m_aUserMgr;
    }

    @Override
    @Nonnull
    public final IRoleManager getRoleManager() {
        return this.m_aRoleMgr;
    }

    @Nonnull
    public static UserGroup createDefaultUserGroupAdministrators() {
        return new UserGroup(StubObject.createForCurrentUserAndID("ugadmin"), "Administrators", (String)null);
    }

    @Nonnull
    public static UserGroup createDefaultUserGroupUsers() {
        return new UserGroup(StubObject.createForCurrentUserAndID("uguser"), "Users", (String)null);
    }

    @Nonnull
    public static UserGroup createDefaultUserGroupGuests() {
        return new UserGroup(StubObject.createForCurrentUserAndID("ugguest"), "Guests", (String)null);
    }

    @Override
    public void createDefaultsForTest() {
        UserGroup userGroup = (UserGroup)this.getOfID("ugadmin");
        if (userGroup == null) {
            userGroup = (UserGroup)this.m_aRWLock.writeLockedGet(() -> (UserGroup)this.internalCreateItem((IHasID)UserGroupManager.createDefaultUserGroupAdministrators()));
        }
        if (this.m_aUserMgr.containsWithID("admin")) {
            userGroup.assignUser("admin");
        }
        if (this.m_aRoleMgr.containsWithID("radmin")) {
            userGroup.assignRole("radmin");
        }
        if ((userGroup = (UserGroup)this.getOfID("uguser")) == null) {
            userGroup = (UserGroup)this.m_aRWLock.writeLockedGet(() -> (UserGroup)this.internalCreateItem((IHasID)UserGroupManager.createDefaultUserGroupUsers()));
        }
        if (this.m_aUserMgr.containsWithID("user")) {
            userGroup.assignUser("user");
        }
        if (this.m_aRoleMgr.containsWithID("ruser")) {
            userGroup.assignRole("ruser");
        }
        if ((userGroup = (UserGroup)this.getOfID("ugguest")) == null) {
            userGroup = (UserGroup)this.m_aRWLock.writeLockedGet(() -> (UserGroup)this.internalCreateItem((IHasID)UserGroupManager.createDefaultUserGroupGuests()));
        }
        if (this.m_aUserMgr.containsWithID("guest")) {
            userGroup.assignUser("guest");
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IUserGroupModificationCallback> userGroupModificationCallbacks() {
        return this.m_aCallbacks;
    }

    @Override
    @Nonnull
    public IUserGroup createNewUserGroup(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable Map<String, String> map) {
        UserGroup userGroup = new UserGroup(string, string2, map);
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem((IHasID)userGroup));
        AuditHelper.onAuditCreateSuccess((ObjectType)UserGroup.OT, (Object[])new Object[]{userGroup.getID(), string, string2, map});
        this.m_aCallbacks.forEach(iUserGroupModificationCallback -> iUserGroupModificationCallback.onUserGroupCreated(userGroup, false));
        return userGroup;
    }

    @Override
    @Nonnull
    public IUserGroup createPredefinedUserGroup(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable Map<String, String> map) {
        UserGroup userGroup = new UserGroup(StubObject.createForCurrentUserAndID(string, map), string2, string3);
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem((IHasID)userGroup));
        AuditHelper.onAuditCreateSuccess((ObjectType)UserGroup.OT, (Object[])new Object[]{userGroup.getID(), "predefined-usergroup", string2, string3, map});
        this.m_aCallbacks.forEach(iUserGroupModificationCallback -> iUserGroupModificationCallback.onUserGroupCreated(userGroup, true));
        return userGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange deleteUserGroup(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return EChange.UNCHANGED;
        }
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditDeleteFailure((ObjectType)UserGroup.OT, (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow(userGroup).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure((ObjectType)UserGroup.OT, (Object[])new Object[]{string, "already-deleted"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemDeleted((IHasID)userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess((ObjectType)UserGroup.OT, (Object[])new Object[]{string});
        this.m_aCallbacks.forEach(iUserGroupModificationCallback -> iUserGroupModificationCallback.onUserGroupDeleted(string));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange undeleteUserGroup(@Nullable String string) {
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditUndeleteFailure((ObjectType)UserGroup.OT, (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setUndeletionNow(userGroup).isUnchanged()) {
                AuditHelper.onAuditUndeleteFailure((ObjectType)UserGroup.OT, (Object[])new Object[]{string, "not-deleted"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemUndeleted((IHasID)userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditUndeleteSuccess((ObjectType)UserGroup.OT, (Object[])new Object[]{string});
        this.m_aCallbacks.forEach(iUserGroupModificationCallback -> iUserGroupModificationCallback.onUserGroupUndeleted(string));
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public IUserGroup getUserGroupOfID(@Nullable String string) {
        return (IUserGroup)this.getOfID(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUserGroup> getAllActiveUserGroups() {
        return this.getAll(iUserGroup -> !iUserGroup.isDeleted());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUserGroup> getAllDeletedUserGroups() {
        return this.getAll(IBusinessObject::isDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange renameUserGroup(@Nullable String string, @Nonnull @Nonempty String string2) {
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)UserGroup.OT, (String)"set-name", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (userGroup.setName(string2).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(userGroup);
            this.internalUpdateItem((IHasID)userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)UserGroup.OT, (String)"set-name", (Object[])new Object[]{string, string2});
        this.m_aCallbacks.forEach(iUserGroupModificationCallback -> iUserGroupModificationCallback.onUserGroupRenamed(string));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange setUserGroupData(@Nullable String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable Map<String, String> map) {
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)UserGroup.OT, (String)"set-all", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = userGroup.setName(string2);
            eChange = eChange.or((IChangeIndicator)userGroup.setDescription(string3));
            eChange = eChange.or((IChangeIndicator)userGroup.attrs().setAll(map));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow(userGroup);
            this.internalUpdateItem((IHasID)userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)UserGroup.OT, (String)"set-all", (Object[])new Object[]{userGroup.getID(), string2, string3, map});
        this.m_aCallbacks.forEach(iUserGroupModificationCallback -> iUserGroupModificationCallback.onUserGroupUpdated(string));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange assignUserToUserGroup(@Nullable String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"UserID");
        if (StringHelper.isEmpty((String)string)) {
            return EChange.UNCHANGED;
        }
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)UserGroup.OT, (String)"assign-user", (Object[])new Object[]{string, string2, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (userGroup.assignUser(string2).isUnchanged()) {
                AuditHelper.onAuditModifyFailure((ObjectType)UserGroup.OT, (String)"assign-user", (Object[])new Object[]{string, string2, "already-assigned"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(userGroup);
            this.internalUpdateItem((IHasID)userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)UserGroup.OT, (String)"assign-user", (Object[])new Object[]{string, string2});
        this.m_aCallbacks.forEach(iUserGroupModificationCallback -> iUserGroupModificationCallback.onUserGroupUserAssignment(string, string2, true));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange unassignUserFromUserGroup(@Nullable String string, @Nullable String string2) {
        if (StringHelper.isEmpty((String)string)) {
            return EChange.UNCHANGED;
        }
        if (StringHelper.isEmpty((String)string2)) {
            return EChange.UNCHANGED;
        }
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)UserGroup.OT, (String)"unassign-user", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (userGroup.unassignUser(string2).isUnchanged()) {
                AuditHelper.onAuditModifyFailure((ObjectType)UserGroup.OT, (String)"unassign-user", (Object[])new Object[]{string, string2, "not-assigned"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(userGroup);
            this.internalUpdateItem((IHasID)userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)UserGroup.OT, (String)"unassign-user", (Object[])new Object[]{string, string2});
        this.m_aCallbacks.forEach(iUserGroupModificationCallback -> iUserGroupModificationCallback.onUserGroupUserAssignment(string, string2, false));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange unassignUserFromAllUserGroups(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return EChange.UNCHANGED;
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.m_aRWLock.writeLock().lock();
        try {
            Object object = EChange.UNCHANGED;
            for (UserGroup userGroup : this.internalDirectGetAll()) {
                if (!userGroup.unassignUser(string).isChanged()) continue;
                commonsArrayList.add((Object)userGroup);
                BusinessObjectHelper.setLastModificationNow(userGroup);
                this.internalUpdateItem((IHasID)userGroup);
                object = EChange.CHANGED;
            }
            if (object.isUnchanged()) {
                Object object2 = EChange.UNCHANGED;
                return object2;
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)UserGroup.OT, (String)"unassign-user-from-all-usergroups", (Object[])new Object[]{string});
        for (Object object2 : commonsArrayList) {
            this.m_aCallbacks.forEach(arg_0 -> UserGroupManager.lambda$unassignUserFromAllUserGroups$14((IUserGroup)object2, string, arg_0));
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUserGroup> getAllUserGroupsWithAssignedUser(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return new CommonsArrayList();
        }
        return this.getAll(iUserGroup -> iUserGroup.containsUserID(string));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllUserGroupIDsWithAssignedUser(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return new CommonsArrayList();
        }
        return this.getAllMapped(iUserGroup -> iUserGroup.containsUserID(string), IHasID::getID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange assignRoleToUserGroup(@Nullable String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"RoleID");
        if (StringHelper.isEmpty((String)string)) {
            return EChange.UNCHANGED;
        }
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)UserGroup.OT, (String)"assign-role", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (userGroup.assignRole(string2).isUnchanged()) {
                AuditHelper.onAuditModifyFailure((ObjectType)UserGroup.OT, (String)"assign-role", (Object[])new Object[]{string, string2, "already-assigned"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(userGroup);
            this.internalUpdateItem((IHasID)userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)UserGroup.OT, (String)"assign-role", (Object[])new Object[]{string, string2});
        this.m_aCallbacks.forEach(iUserGroupModificationCallback -> iUserGroupModificationCallback.onUserGroupRoleAssignment(string, string2, true));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange unassignRoleFromUserGroup(@Nullable String string, @Nullable String string2) {
        if (StringHelper.isEmpty((String)string)) {
            return EChange.UNCHANGED;
        }
        if (StringHelper.isEmpty((String)string2)) {
            return EChange.UNCHANGED;
        }
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditModifyFailure((ObjectType)UserGroup.OT, (String)"unassign-role", (Object[])new Object[]{string, "no-such-id"});
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (userGroup.unassignRole(string2).isUnchanged()) {
                AuditHelper.onAuditModifyFailure((ObjectType)UserGroup.OT, (String)"unassign-role", (Object[])new Object[]{string, string2, "not-assigned"});
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(userGroup);
            this.internalUpdateItem((IHasID)userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)UserGroup.OT, (String)"unassign-role", (Object[])new Object[]{string, string2});
        this.m_aCallbacks.forEach(iUserGroupModificationCallback -> iUserGroupModificationCallback.onUserGroupRoleAssignment(string, string2, false));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange unassignRoleFromAllUserGroups(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return EChange.UNCHANGED;
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.m_aRWLock.writeLock().lock();
        try {
            Object object = EChange.UNCHANGED;
            for (UserGroup userGroup : this.internalDirectGetAll()) {
                if (!userGroup.unassignRole(string).isChanged()) continue;
                commonsArrayList.add((Object)userGroup);
                BusinessObjectHelper.setLastModificationNow(userGroup);
                this.internalUpdateItem((IHasID)userGroup);
                object = EChange.CHANGED;
            }
            if (object.isUnchanged()) {
                Object object2 = EChange.UNCHANGED;
                return object2;
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess((ObjectType)UserGroup.OT, (String)"unassign-role-from-all-usergroups", (Object[])new Object[]{string});
        for (Object object2 : commonsArrayList) {
            this.m_aCallbacks.forEach(arg_0 -> UserGroupManager.lambda$unassignRoleFromAllUserGroups$19((IUserGroup)object2, string, arg_0));
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUserGroup> getAllUserGroupsWithAssignedRole(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return this.getNone();
        }
        return this.getAll(iUserGroup -> iUserGroup.containsRoleID(string));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllUserGroupIDsWithAssignedRole(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return this.getNone();
        }
        return this.getAllMapped(iUserGroup -> iUserGroup.containsRoleID(string), IHasID::getID);
    }

    @Override
    public boolean containsUserGroupWithAssignedRole(@Nullable String string) {
        return this.containsAny(iUserGroup -> iUserGroup.containsRoleID(string));
    }

    @Override
    public boolean containsAnyUserGroupWithAssignedUserAndRole(@Nullable String string, @Nullable String string2) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        if (StringHelper.isEmpty((String)string2)) {
            return false;
        }
        return this.containsAny(iUserGroup -> iUserGroup.containsUserID(string) && iUserGroup.containsRoleID(string2));
    }

    private static /* synthetic */ void lambda$unassignRoleFromAllUserGroups$19(IUserGroup iUserGroup, String string, IUserGroupModificationCallback iUserGroupModificationCallback) {
        iUserGroupModificationCallback.onUserGroupRoleAssignment((String)iUserGroup.getID(), string, false);
    }

    private static /* synthetic */ void lambda$unassignUserFromAllUserGroups$14(IUserGroup iUserGroup, String string, IUserGroupModificationCallback iUserGroupModificationCallback) {
        iUserGroupModificationCallback.onUserGroupUserAssignment((String)iUserGroup.getID(), string, false);
    }
}

