/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.user;

import com.helger.annotation.Nonempty;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.object.AbstractBusinessObjectMicroTypeConverter;
import com.helger.photon.security.token.accesstoken.AccessToken;
import com.helger.photon.security.token.accesstoken.IAccessToken;
import com.helger.photon.security.token.user.UserToken;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.IUserManager;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;

public final class UserTokenMicroTypeConverter
extends AbstractBusinessObjectMicroTypeConverter<UserToken> {
    private static final String ELEMENT_ACCESS_TOKEN = "accesstoken";
    private static final IMicroQName ATTR_USER_ID = new MicroQName("userid");
    private static final String ELEMENT_DESCRIPTION = "description";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull UserToken userToken, @Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        UserTokenMicroTypeConverter.setObjectFields(userToken, (IMicroElement)microElement);
        for (IAccessToken iAccessToken : userToken.getAccessTokenList().getAllAccessTokens()) {
            microElement.addChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)iAccessToken, (String)string, (String)ELEMENT_ACCESS_TOKEN));
        }
        microElement.setAttribute(ATTR_USER_ID, (String)userToken.getUser().getID());
        if (StringHelper.isNotEmpty((String)userToken.getDescription())) {
            microElement.addElementNS(string, ELEMENT_DESCRIPTION).addText((CharSequence)userToken.getDescription());
        }
        return microElement;
    }

    @Nonnull
    public UserToken convertToNative(@Nonnull IMicroElement iMicroElement) {
        Object object2;
        IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object object2 : iMicroElement.getAllChildElements(ELEMENT_ACCESS_TOKEN)) {
            commonsArrayList.add((Object)((AccessToken)MicroTypeConverter.convertToNative((IMicroElement)object2, AccessToken.class)));
        }
        String string = iMicroElement.getAttributeValue(ATTR_USER_ID);
        object2 = iUserManager.getUserOfID(string);
        if (object2 == null) {
            throw new IllegalStateException("Failed to resolve user with ID '" + (String)string + "'");
        }
        String string2 = MicroHelper.getChildTextContentTrimmed((IMicroElement)iMicroElement, (String)ELEMENT_DESCRIPTION);
        return new UserToken(UserTokenMicroTypeConverter.getStubObject(iMicroElement), (List<AccessToken>)commonsArrayList, (IUser)object2, string2);
    }
}

