/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.revocation;

import com.helger.annotation.Nonempty;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.photon.security.token.revocation.RevocationStatus;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;

public final class RevocationStatusMicroTypeConverter
implements IMicroTypeConverter<RevocationStatus> {
    private static final String ATTR_IS_REVOKED = "isrevoked";
    private static final String ATTR_USER_ID = "ruserid";
    private static final String ATTR_DT = "rdt";
    private static final String ELEMENT_REASON = "reason";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull RevocationStatus revocationStatus, @Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_IS_REVOKED, revocationStatus.isRevoked());
        microElement.setAttribute(ATTR_USER_ID, revocationStatus.getRevocationUserID());
        microElement.setAttributeWithConversion(ATTR_DT, (Object)revocationStatus.getRevocationDateTime());
        if (StringHelper.isNotEmpty((String)revocationStatus.getRevocationReason())) {
            microElement.addElementNS(string, ELEMENT_REASON).addText((CharSequence)revocationStatus.getRevocationReason());
        }
        return microElement;
    }

    @Nonnull
    public RevocationStatus convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_IS_REVOKED);
        boolean bl = StringParser.parseBool((String)string);
        String string2 = iMicroElement.getAttributeValue(ATTR_USER_ID);
        LocalDateTime localDateTime = (LocalDateTime)iMicroElement.getAttributeValueWithConversion(ATTR_DT, LocalDateTime.class);
        String string3 = MicroHelper.getChildTextContent((IMicroElement)iMicroElement, (String)ELEMENT_REASON);
        return new RevocationStatus(bl, string2, localDateTime, string3);
    }
}

