/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.revocation;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.photon.security.token.revocation.IRevocationStatus;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;

@NotThreadSafe
public class RevocationStatus
implements IRevocationStatus {
    private boolean m_bRevoked;
    private String m_sRevocationUserID;
    private LocalDateTime m_aRevocationDT;
    private String m_sRevocationReason;

    public RevocationStatus(boolean bl, @Nullable String string, @Nullable LocalDateTime localDateTime, @Nullable String string2) {
        if (bl) {
            ValueEnforcer.notEmpty((CharSequence)string, (String)"RevocationUserID");
            ValueEnforcer.notNull((Object)localDateTime, (String)"RevocationDT");
            ValueEnforcer.notEmpty((CharSequence)string2, (String)"RevocationReason");
        }
        this.m_bRevoked = bl;
        this.m_sRevocationUserID = string;
        this.m_aRevocationDT = localDateTime;
        this.m_sRevocationReason = string2;
    }

    @Override
    public final boolean isRevoked() {
        return this.m_bRevoked;
    }

    @Override
    @Nullable
    public final String getRevocationUserID() {
        return this.m_sRevocationUserID;
    }

    @Override
    @Nullable
    public final LocalDateTime getRevocationDateTime() {
        return this.m_aRevocationDT;
    }

    @Override
    @Nullable
    public final String getRevocationReason() {
        return this.m_sRevocationReason;
    }

    public void markRevoked(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RevocationUserID");
        ValueEnforcer.notNull((Object)localDateTime, (String)"RevocationDT");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"RevocationReason");
        if (this.m_bRevoked) {
            throw new IllegalStateException("This object is already revoked!");
        }
        this.m_bRevoked = true;
        this.m_sRevocationUserID = string;
        this.m_aRevocationDT = localDateTime;
        this.m_sRevocationReason = string2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        RevocationStatus revocationStatus = (RevocationStatus)object;
        return this.m_bRevoked == revocationStatus.m_bRevoked && EqualsHelper.equals((Object)this.m_sRevocationUserID, (Object)revocationStatus.m_sRevocationUserID) && EqualsHelper.equals((Object)this.m_aRevocationDT, (Object)revocationStatus.m_aRevocationDT) && EqualsHelper.equals((Object)this.m_sRevocationReason, (Object)revocationStatus.m_sRevocationReason);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_bRevoked).append((Object)this.m_sRevocationUserID).append((Object)this.m_aRevocationDT).append((Object)this.m_sRevocationReason).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("revoked", this.m_bRevoked).appendIfNotNull("RevocationUserID", (Object)this.m_sRevocationUserID).appendIfNotNull("RevocationDT", (Object)this.m_aRevocationDT).appendIfNotNull("RevocationReason", (Object)this.m_sRevocationReason).getToString();
    }

    @Nonnull
    public static RevocationStatus createUnrevoked() {
        return new RevocationStatus(false, null, null, null);
    }
}

