/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.object;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.photon.security.token.accesstoken.AccessToken;
import com.helger.photon.security.token.accesstoken.IAccessToken;
import com.helger.photon.security.token.object.IAccessTokenList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.function.Predicate;

public class AccessTokenList
implements IAccessTokenList {
    private final ICommonsList<AccessToken> m_aAccessTokens;
    private AccessToken m_aActiveAccessToken;

    @Nullable
    protected static AccessToken _getIfNotRevoked(@Nullable AccessToken accessToken) {
        return accessToken != null && !accessToken.isRevoked() ? accessToken : null;
    }

    public AccessTokenList(@Nonnull @Nonempty List<AccessToken> list) {
        ValueEnforcer.notEmptyNoNullValue(list, (String)"AccessTokens");
        this.m_aAccessTokens = new CommonsArrayList(list);
        this.m_aActiveAccessToken = AccessTokenList._getIfNotRevoked((AccessToken)CollectionFind.getLastElement(list));
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<AccessToken> getAllAccessTokens() {
        return (ICommonsList)this.m_aAccessTokens.getClone();
    }

    @Override
    @Nullable
    public IAccessToken findFirstAccessToken(@Nullable Predicate<? super IAccessToken> predicate) {
        return (IAccessToken)this.m_aAccessTokens.findFirst(predicate);
    }

    @Override
    @Nullable
    public IAccessToken getActiveAccessToken() {
        return this.m_aActiveAccessToken;
    }

    @Nonnull
    public EChange revokeActiveAccessToken(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string2) {
        if (this.m_aActiveAccessToken == null) {
            return EChange.UNCHANGED;
        }
        this.m_aActiveAccessToken.markRevoked(string, localDateTime, string2);
        this.m_aActiveAccessToken.setNotAfter(localDateTime);
        this.m_aActiveAccessToken = null;
        return EChange.CHANGED;
    }

    @Nonnull
    public AccessToken createNewAccessToken(@Nullable String string) {
        if (this.m_aActiveAccessToken != null) {
            throw new IllegalStateException("You need to revoke the previous access token before creating a new one!");
        }
        AccessToken accessToken = AccessToken.createAccessTokenValidFromNow(string);
        this.m_aAccessTokens.add((Object)accessToken);
        this.m_aActiveAccessToken = accessToken;
        return accessToken;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("AccessTokens", this.m_aAccessTokens).append("ActiveAccessToken", (Object)this.m_aActiveAccessToken).getToString();
    }
}

