/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.accesstoken;

import com.helger.annotation.Nonempty;
import com.helger.datetime.helper.PDTFactory;
import com.helger.photon.security.token.revocation.IRevocationStatus;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;

public interface IAccessToken {
    public static final int TOKEN_STRING_MAX_LENGTH = 200;

    @Nonnull
    @Nonempty
    public String getTokenString();

    @Nonnull
    public LocalDateTime getNotBefore();

    @Nullable
    public LocalDateTime getNotAfter();

    default public boolean isValidNow() {
        return this.isValidAt(PDTFactory.getCurrentLocalDateTime());
    }

    public boolean isValidAt(@Nonnull LocalDateTime var1);

    @Nonnull
    public IRevocationStatus getRevocationStatus();

    default public boolean isRevoked() {
        return this.getRevocationStatus().isRevoked();
    }
}

