/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.role;

import com.helger.base.string.StringHelper;
import com.helger.photon.security.object.AbstractBusinessObjectMicroTypeConverter;
import com.helger.photon.security.role.Role;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.util.MicroHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public final class RoleMicroTypeConverter
extends AbstractBusinessObjectMicroTypeConverter<Role> {
    private static final IMicroQName ATTR_NAME = new MicroQName("name");
    private static final String ELEMENT_DESCRIPTION = "description";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull Role role, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        RoleMicroTypeConverter.setObjectFields(role, (IMicroElement)microElement);
        microElement.setAttribute(ATTR_NAME, role.getName());
        if (StringHelper.isNotEmpty((String)role.getDescription())) {
            microElement.addElementNS(string, ELEMENT_DESCRIPTION).addText((CharSequence)role.getDescription());
        }
        return microElement;
    }

    @Nonnull
    public Role convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_NAME);
        String string2 = MicroHelper.getChildTextContentTrimmed((IMicroElement)iMicroElement, (String)ELEMENT_DESCRIPTION);
        return new Role(RoleMicroTypeConverter.getStubObject(iMicroElement), string, string2);
    }
}

