/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.object;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.datetime.helper.PDTFactory;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.tenancy.AbstractBusinessObject;
import jakarta.annotation.Nonnull;

@Immutable
public final class BusinessObjectHelper {
    private BusinessObjectHelper() {
    }

    @Nonnull
    @Nonempty
    public static String getUserIDOrFallback() {
        String string = LoggedInUserManager.getInstance().getCurrentUserID();
        if (StringHelper.isEmpty((String)string)) {
            string = "$GUEST$";
        }
        return string;
    }

    public static void setLastModificationNow(@Nonnull AbstractBusinessObject abstractBusinessObject) {
        abstractBusinessObject.setLastModification(PDTFactory.getCurrentLocalDateTime(), BusinessObjectHelper.getUserIDOrFallback());
    }

    @Nonnull
    public static EChange setDeletionNow(@Nonnull AbstractBusinessObject abstractBusinessObject) {
        return abstractBusinessObject.setDeletion(PDTFactory.getCurrentLocalDateTime(), BusinessObjectHelper.getUserIDOrFallback());
    }

    @Nonnull
    public static EChange setUndeletionNow(@Nonnull AbstractBusinessObject abstractBusinessObject) {
        return abstractBusinessObject.setUndeletion(PDTFactory.getCurrentLocalDateTime(), BusinessObjectHelper.getUserIDOrFallback());
    }
}

