/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.object;

import com.helger.annotation.misc.ContainsSoftMigration;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.helper.CollectionSort;
import com.helger.photon.security.object.StubObject;
import com.helger.tenancy.IBusinessObject;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

public abstract class AbstractBusinessObjectMicroTypeConverter<T extends IBusinessObject>
implements IMicroTypeConverter<T> {
    protected static final IMicroQName ATTR_ID = new MicroQName("id");
    protected static final IMicroQName ATTR_CREATIONLDT = new MicroQName("creationldt");
    protected static final IMicroQName ATTR_CREATIONUSERID = new MicroQName("creationuserid");
    protected static final IMicroQName ATTR_LASTMODLDT = new MicroQName("lastmodldt");
    protected static final IMicroQName ATTR_LASTMODUSERID = new MicroQName("lastmoduserid");
    protected static final IMicroQName ATTR_DELETIONLDT = new MicroQName("deletionldt");
    protected static final IMicroQName ATTR_DELETIONUSERID = new MicroQName("deletionuserid");
    protected static final String ELEMENT_CUSTOM = "custom";

    protected AbstractBusinessObjectMicroTypeConverter() {
    }

    public static final void setObjectFields(@Nonnull IBusinessObject iBusinessObject, @Nonnull IMicroElement iMicroElement) {
        iMicroElement.setAttribute(ATTR_ID, (String)iBusinessObject.getID());
        iMicroElement.setAttributeWithConversion(ATTR_CREATIONLDT, (Object)iBusinessObject.getCreationDateTime());
        iMicroElement.setAttribute(ATTR_CREATIONUSERID, iBusinessObject.getCreationUserID());
        iMicroElement.setAttributeWithConversion(ATTR_LASTMODLDT, (Object)iBusinessObject.getLastModificationDateTime());
        iMicroElement.setAttribute(ATTR_LASTMODUSERID, iBusinessObject.getLastModificationUserID());
        iMicroElement.setAttributeWithConversion(ATTR_DELETIONLDT, (Object)iBusinessObject.getDeletionDateTime());
        iMicroElement.setAttribute(ATTR_DELETIONUSERID, iBusinessObject.getDeletionUserID());
        for (Map.Entry entry : CollectionSort.getSortedByKey((Map)iBusinessObject.attrs()).entrySet()) {
            IMicroElement iMicroElement2 = iMicroElement.addElementNS(iMicroElement.getNamespaceURI(), ELEMENT_CUSTOM);
            iMicroElement2.setAttribute(ATTR_ID, (String)entry.getKey());
            iMicroElement2.addText((CharSequence)entry.getValue());
        }
    }

    @Nullable
    @ContainsSoftMigration
    public static LocalDateTime readAsLocalDateTime(@Nonnull IMicroElement iMicroElement, @Nonnull IMicroQName iMicroQName, @Nonnull String string) {
        ZonedDateTime zonedDateTime;
        LocalDateTime localDateTime = (LocalDateTime)iMicroElement.getAttributeValueWithConversion(iMicroQName, LocalDateTime.class);
        if (localDateTime == null && (zonedDateTime = (ZonedDateTime)iMicroElement.getAttributeValueWithConversion(string, ZonedDateTime.class)) != null) {
            localDateTime = zonedDateTime.toLocalDateTime();
        }
        return localDateTime;
    }

    @Nonnull
    public static final StubObject getStubObject(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_ID);
        LocalDateTime localDateTime = AbstractBusinessObjectMicroTypeConverter.readAsLocalDateTime(iMicroElement, ATTR_CREATIONLDT, "creationdt");
        String string2 = iMicroElement.getAttributeValue(ATTR_CREATIONUSERID);
        LocalDateTime localDateTime2 = AbstractBusinessObjectMicroTypeConverter.readAsLocalDateTime(iMicroElement, ATTR_LASTMODLDT, "lastmodldt");
        String string3 = iMicroElement.getAttributeValue(ATTR_LASTMODUSERID);
        LocalDateTime localDateTime3 = AbstractBusinessObjectMicroTypeConverter.readAsLocalDateTime(iMicroElement, ATTR_DELETIONLDT, "deletiondt");
        String string4 = iMicroElement.getAttributeValue(ATTR_DELETIONUSERID);
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_CUSTOM)) {
            commonsLinkedHashMap.put((Object)iMicroElement2.getAttributeValue(ATTR_ID), (Object)iMicroElement2.getTextContent());
        }
        return new StubObject(string, localDateTime, string2, localDateTime2, string3, localDateTime3, string4, (Map<String, String>)commonsLinkedHashMap);
    }
}

