/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.login;

import com.helger.photon.security.login.ELoginResultText;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import com.helger.text.display.IHasDisplayText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public enum ELoginResult implements ICredentialValidationResult
{
    SUCCESS(ELoginResultText.SUCCESS),
    SUCCESS_WITH_LOGOUT(ELoginResultText.SUCCESS_WITH_LOGOUT),
    USER_NOT_EXISTING(ELoginResultText.USER_NOT_EXISTING),
    USER_IS_DELETED(ELoginResultText.USER_IS_DELETED),
    USER_IS_DISABLED(ELoginResultText.USER_IS_DISABLED),
    USER_IS_MISSING_ROLE(ELoginResultText.USER_IS_MISSING_ROLE),
    INVALID_PASSWORD(ELoginResultText.INVALID_PASSWORD),
    USER_ALREADY_LOGGED_IN(ELoginResultText.USER_ALREADY_LOGGED_IN),
    SESSION_ALREADY_HAS_USER(ELoginResultText.SESSION_ALREADY_HAS_USER),
    TOKEN_NOT_EXISTING(ELoginResultText.TOKEN_NOT_EXISTING);

    private final IHasDisplayText m_aErrorMsg;

    private ELoginResult(IHasDisplayText iHasDisplayText) {
        this.m_aErrorMsg = iHasDisplayText;
    }

    public boolean isSuccess() {
        return this == SUCCESS || this == SUCCESS_WITH_LOGOUT;
    }

    public boolean hasMessage() {
        return this != SUCCESS;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aErrorMsg.getDisplayText(locale);
    }
}

