/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.lock;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.helper.PDTFactory;
import com.helger.photon.security.lock.ILockInfo;
import jakarta.annotation.Nonnull;
import java.time.LocalDateTime;

@Immutable
public final class LockInfo
implements ILockInfo {
    private final String m_sUserID;
    private final LocalDateTime m_aLockTime;

    public LockInfo(@Nonnull @Nonempty String string) {
        this.m_sUserID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"UserID");
        this.m_aLockTime = PDTFactory.getCurrentLocalDateTime();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getLockUserID() {
        return this.m_sUserID;
    }

    @Override
    @Nonnull
    public LocalDateTime getLockDateTime() {
        return this.m_aLockTime;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LockInfo lockInfo = (LockInfo)object;
        return this.m_sUserID.equals(lockInfo.m_sUserID) && this.m_aLockTime.equals(lockInfo.m_aLockTime);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sUserID).append((Object)this.m_aLockTime).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("userID", (Object)this.m_sUserID).append("lockTime", (Object)this.m_aLockTime).getToString();
    }
}

