/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode.html;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCHasID;
import com.helger.html.jscode.AbstractJSVariable;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSAssignment;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSFieldRef;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.jscode.JSRef;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class JSHtml {
    private static final JSHtml INSTANCE = new JSHtml();

    private JSHtml() {
    }

    @Nonnull
    public static JSRef console() {
        return JSExpr.ref("console");
    }

    @Nonnull
    public static JSInvocation consoleAssert() {
        return JSHtml.console().invoke("assert");
    }

    @Nonnull
    public static JSInvocation consoleClear() {
        return JSHtml.console().invoke("clear");
    }

    @Nonnull
    public static JSInvocation consoleDebug() {
        return JSHtml.console().invoke("debug");
    }

    @Nonnull
    public static JSInvocation consoleError() {
        return JSHtml.console().invoke("error");
    }

    @Nonnull
    public static JSInvocation consoleInfo() {
        return JSHtml.console().invoke("info");
    }

    @Nonnull
    public static JSInvocation consoleLog() {
        return JSHtml.console().invoke("log");
    }

    @Nonnull
    public static JSInvocation consoleLog(@Nullable String string) {
        return (JSInvocation)JSHtml.consoleLog().arg(string);
    }

    @Nonnull
    public static JSInvocation consoleLog(@Nonnull IJSExpression iJSExpression) {
        return (JSInvocation)JSHtml.consoleLog().arg(iJSExpression);
    }

    @Nonnull
    public static JSInvocation consoleWarn() {
        return JSHtml.console().invoke("warn");
    }

    @Nonnull
    public static JSRef document() {
        return JSExpr.ref("document");
    }

    @Nonnull
    public static JSFieldRef documentAnchors() {
        return JSHtml.document().ref("anchors");
    }

    @Nonnull
    public static JSInvocation documentAddEventListener() {
        return JSHtml.document().invoke("addEventListener");
    }

    @Nonnull
    public static JSInvocation documentCreateAttribute() {
        return JSHtml.document().invoke("createAttribute");
    }

    @Nonnull
    public static JSInvocation documentCreateElement() {
        return JSHtml.document().invoke("createElement");
    }

    @Nonnull
    public static JSInvocation documentCreateElement(@Nonnull EHTMLElement eHTMLElement) {
        return (JSInvocation)JSHtml.documentCreateElement().arg(new EHTMLElement[]{eHTMLElement});
    }

    @Nonnull
    public static JSInvocation documentCreateTextNode() {
        return JSHtml.document().invoke("createTextNode");
    }

    @Nonnull
    public static JSFieldRef documentEmbeds() {
        return JSHtml.document().ref("embeds");
    }

    @Nonnull
    public static JSFieldRef documentForms() {
        return JSHtml.document().ref("forms");
    }

    @Nonnull
    public static JSInvocation documentGetElementById(@Nonnull String string) {
        return JSHtml.documentGetElementById(JSExpr.lit(string));
    }

    @Nonnull
    public static JSInvocation documentGetElementById(@Nonnull IHCHasID<?> iHCHasID) {
        return JSHtml.documentGetElementById(iHCHasID.ensureID().getID());
    }

    @Nonnull
    public static JSInvocation documentGetElementById(@Nonnull IJSExpression iJSExpression) {
        return (JSInvocation)JSHtml.document().invoke("getElementById").arg(iJSExpression);
    }

    @Nonnull
    public static JSInvocation documentGetElementsByName(@Nonnull EHTMLElement eHTMLElement) {
        return JSHtml.documentGetElementsByName(eHTMLElement.getElementName());
    }

    @Nonnull
    public static JSInvocation documentGetElementsByName(@Nonnull String string) {
        return JSHtml.documentGetElementsByName(JSExpr.lit(string));
    }

    @Nonnull
    public static JSInvocation documentGetElementsByName(@Nonnull IJSExpression iJSExpression) {
        return (JSInvocation)JSHtml.document().invoke("getElementsByName").arg(iJSExpression);
    }

    @Nonnull
    public static JSInvocation documentGetElementsByTagName(@Nonnull EHTMLElement eHTMLElement) {
        return JSHtml.documentGetElementsByTagName(eHTMLElement.getElementName());
    }

    @Nonnull
    public static JSInvocation documentGetElementsByTagName(@Nonnull String string) {
        return JSHtml.documentGetElementsByTagName(JSExpr.lit(string));
    }

    @Nonnull
    public static JSInvocation documentGetElementsByTagName(@Nonnull IJSExpression iJSExpression) {
        return (JSInvocation)JSHtml.document().invoke("getElementsByTagName").arg(iJSExpression);
    }

    @Nonnull
    public static JSFieldRef documentImages() {
        return JSHtml.document().ref("images");
    }

    @Nonnull
    public static JSFieldRef documentLinks() {
        return JSHtml.document().ref("links");
    }

    @Nonnull
    public static JSInvocation documentWrite(@Nonnull String string) {
        return JSHtml.documentWrite(JSExpr.lit(string));
    }

    @Nonnull
    public static JSInvocation documentWrite(@Nonnull IJSExpression iJSExpression) {
        return (JSInvocation)JSHtml.document().invoke("write").arg(iJSExpression);
    }

    @Nonnull
    public static JSInvocation documentWriteln(@Nonnull String string) {
        return JSHtml.documentWriteln(JSExpr.lit(string));
    }

    @Nonnull
    public static JSInvocation documentWriteln(@Nonnull IJSExpression iJSExpression) {
        return (JSInvocation)JSHtml.document().invoke("writeln").arg(iJSExpression);
    }

    @Nonnull
    public static JSRef event() {
        return JSExpr.ref("event");
    }

    @Nonnull
    public static JSRef history() {
        return JSExpr.ref("history");
    }

    @Nonnull
    public static JSInvocation historyBack() {
        return JSHtml.history().invoke("back");
    }

    @Nonnull
    public static JSInvocation historyForward() {
        return JSHtml.history().invoke("forward");
    }

    @Nonnull
    public static JSInvocation historyGo(int n) {
        return JSHtml.historyGo(JSExpr.lit(n));
    }

    @Nonnull
    public static JSInvocation historyGo(@Nonnull IJSExpression iJSExpression) {
        return (JSInvocation)JSHtml.history().invoke("go").arg(iJSExpression);
    }

    @Nonnull
    public static JSFieldRef historyLength() {
        return JSHtml.history().ref("length");
    }

    @Nonnull
    public static JSRef navigator() {
        return JSExpr.ref("navigator");
    }

    @Nonnull
    public static JSFieldRef navigatorAppCodeName() {
        return JSHtml.navigator().ref("appCodeName");
    }

    @Nonnull
    public static JSFieldRef navigatorAppName() {
        return JSHtml.navigator().ref("appName");
    }

    @Nonnull
    public static JSFieldRef navigatorAppVersion() {
        return JSHtml.navigator().ref("appVersion");
    }

    @Nonnull
    public static JSFieldRef navigatorCookieEnabled() {
        return JSHtml.navigator().ref("cookieEnabled");
    }

    @Nonnull
    public static JSFieldRef navigatorLanguage() {
        return JSHtml.navigator().ref("language");
    }

    @Nonnull
    public static JSFieldRef navigatorMimeTypes() {
        return JSHtml.navigator().ref("mimeTypes");
    }

    @Nonnull
    public static JSFieldRef navigatorOnLine() {
        return JSHtml.navigator().ref("onLine");
    }

    @Nonnull
    public static JSFieldRef navigatorPlatform() {
        return JSHtml.navigator().ref("platform");
    }

    @Nonnull
    public static JSFieldRef navigatorPlugins() {
        return JSHtml.navigator().ref("plugins");
    }

    @Nonnull
    public static JSFieldRef navigatorUserAgent() {
        return JSHtml.navigator().ref("userAgent");
    }

    @Nonnull
    public static JSInvocation navigatorJavaEnabled() {
        return JSHtml.navigator().invoke("javaEnabled");
    }

    @Nonnull
    public static JSInvocation navigatorTaintEnabled() {
        return JSHtml.navigator().invoke("taintEnabled");
    }

    @Nonnull
    public static JSRef screen() {
        return JSExpr.ref("screen");
    }

    @Nonnull
    public static JSFieldRef screenAvailHeight() {
        return JSHtml.screen().ref("availHeight");
    }

    @Nonnull
    public static JSFieldRef screenAvailWidth() {
        return JSHtml.screen().ref("availWidth");
    }

    @Nonnull
    public static JSFieldRef screenColorDepth() {
        return JSHtml.screen().ref("colorDepth");
    }

    @Nonnull
    public static JSFieldRef screenHeight() {
        return JSHtml.screen().ref("height");
    }

    @Nonnull
    public static JSFieldRef screenPixelDepth() {
        return JSHtml.screen().ref("pixelDepth");
    }

    @Nonnull
    public static JSFieldRef screenWidth() {
        return JSHtml.screen().ref("width");
    }

    @Nonnull
    public static JSRef window() {
        return JSExpr.ref("window");
    }

    @Nonnull
    public static JSInvocation windowAlert() {
        return JSHtml.window().invoke("alert");
    }

    @Nonnull
    public static JSInvocation windowAlert(@Nullable String string) {
        return (JSInvocation)JSHtml.windowAlert().arg(string);
    }

    @Nonnull
    public static JSInvocation windowAlert(@Nonnull IJSExpression iJSExpression) {
        return (JSInvocation)JSHtml.windowAlert().arg(iJSExpression);
    }

    @Nonnull
    public static JSInvocation windowBlur() {
        return JSHtml.window().invoke("blur");
    }

    @Nonnull
    public static JSInvocation windowClearInterval() {
        return JSHtml.window().invoke("clearInterval");
    }

    @Nonnull
    public static JSInvocation windowClearInterval(@Nonnull AbstractJSVariable<?> abstractJSVariable) {
        return (JSInvocation)JSHtml.windowClearInterval().arg(abstractJSVariable);
    }

    @Nonnull
    public static JSInvocation windowClearTimeout() {
        return JSHtml.window().invoke("clearTimeout");
    }

    @Nonnull
    public static JSInvocation windowClearTimeout(@Nonnull AbstractJSVariable<?> abstractJSVariable) {
        return (JSInvocation)JSHtml.windowClearTimeout().arg(abstractJSVariable);
    }

    @Nonnull
    public static JSInvocation windowClose() {
        return JSHtml.window().invoke("close");
    }

    @Nonnull
    public static JSFieldRef windowClosed() {
        return JSHtml.window().ref("closed");
    }

    @Nonnull
    public static JSInvocation windowConfirm() {
        return JSHtml.window().invoke("confirm");
    }

    @Nonnull
    public static JSFieldRef windowConsole() {
        return JSHtml.window().ref("console");
    }

    @Nonnull
    public static JSInvocation windowCreatePopup() {
        return JSHtml.window().invoke("createPopup");
    }

    @Nonnull
    public static JSFieldRef windowDefaultStatus() {
        return JSHtml.window().ref("defaultStatus");
    }

    @Nonnull
    public static JSFieldRef windowDocument() {
        return JSHtml.window().ref("document");
    }

    @Nonnull
    public static JSInvocation windowFocus() {
        return JSHtml.window().invoke("focus");
    }

    @Nonnull
    public static JSFieldRef windowFrames() {
        return JSHtml.window().ref("frames");
    }

    @Nonnull
    public static JSFieldRef windowHistory() {
        return JSHtml.window().ref("history");
    }

    @Nonnull
    public static JSFieldRef windowInnerHeight() {
        return JSHtml.window().ref("innerHeight");
    }

    @Nonnull
    public static JSFieldRef windowInnerWidth() {
        return JSHtml.window().ref("innerWidth");
    }

    @Nonnull
    public static JSFieldRef windowLength() {
        return JSHtml.window().ref("length");
    }

    @Nonnull
    public static JSFieldRef windowLocalStorage() {
        return JSHtml.window().ref("localStorage");
    }

    @Nonnull
    public static JSFieldRef windowLocation() {
        return JSHtml.window().ref("location");
    }

    @Nonnull
    public static JSFieldRef windowLocationHash() {
        return JSHtml.windowLocation().ref("hash");
    }

    @Nonnull
    public static JSFieldRef windowLocationHost() {
        return JSHtml.windowLocation().ref("host");
    }

    @Nonnull
    public static JSFieldRef windowLocationHostname() {
        return JSHtml.windowLocation().ref("hostname");
    }

    @Nonnull
    public static JSFieldRef windowLocationHref() {
        return JSHtml.windowLocation().ref("href");
    }

    @Nonnull
    @DevelopersNote(value="Should be deprecated but is used too often")
    public static JSAssignment windowLocationHref(@Nonnull ISimpleURL iSimpleURL) {
        return JSHtml.windowLocationHref().assign(iSimpleURL.getAsString());
    }

    @Nonnull
    public static JSFieldRef windowLocationPathname() {
        return JSHtml.windowLocation().ref("pathname");
    }

    @Nonnull
    public static JSFieldRef windowLocationPort() {
        return JSHtml.windowLocation().ref("port");
    }

    @Nonnull
    public static JSFieldRef windowLocationProtocol() {
        return JSHtml.windowLocation().ref("protocol");
    }

    @Nonnull
    public static JSInvocation windowLocationReload() {
        return JSHtml.windowLocation().invoke("reload");
    }

    @Nonnull
    public static JSInvocation windowLocationReplace() {
        return JSHtml.windowLocation().invoke("replace");
    }

    @Nonnull
    public static JSInvocation windowLocationReplace(@Nonnull ISimpleURL iSimpleURL) {
        return JSHtml.windowLocationReplace(JSExpr.lit(iSimpleURL.getAsString()));
    }

    @Nonnull
    public static JSInvocation windowLocationReplace(@Nonnull IJSExpression iJSExpression) {
        return (JSInvocation)JSHtml.windowLocationReplace().arg(iJSExpression);
    }

    @Nonnull
    public static JSFieldRef windowLocationSearch() {
        return JSHtml.windowLocation().ref("search");
    }

    @Nonnull
    public static JSInvocation windowMoveBy() {
        return JSHtml.window().invoke("moveBy");
    }

    @Nonnull
    public static JSInvocation windowMoveTo() {
        return JSHtml.window().invoke("moveTo");
    }

    @Nonnull
    public static JSFieldRef windowName() {
        return JSHtml.window().ref("name");
    }

    @Nonnull
    public static JSFieldRef windowNavigator() {
        return JSHtml.window().ref("navigator");
    }

    @Nonnull
    public static JSInvocation windowOpen() {
        return JSHtml.window().invoke("open");
    }

    @Nonnull
    public static JSFieldRef windowOpener() {
        return JSHtml.window().ref("opener");
    }

    @Nonnull
    public static JSFieldRef windowOuterHeight() {
        return JSHtml.window().ref("outerHeight");
    }

    @Nonnull
    public static JSFieldRef windowOuterWidth() {
        return JSHtml.window().ref("outerWidth");
    }

    @Nonnull
    public static JSFieldRef windowPageXOffset() {
        return JSHtml.window().ref("pageXOffset");
    }

    @Nonnull
    public static JSFieldRef windowPageYOffset() {
        return JSHtml.window().ref("pageYOffset");
    }

    @Nonnull
    public static JSFieldRef windowParent() {
        return JSHtml.window().ref("parent");
    }

    @Nonnull
    public static JSFieldRef windowParentFrames() {
        return JSHtml.windowParent().ref("frames");
    }

    @Nonnull
    public static JSInvocation windowPrint() {
        return JSHtml.window().invoke("print");
    }

    @Nonnull
    public static JSInvocation windowPrompt() {
        return JSHtml.window().invoke("prompt");
    }

    @Nonnull
    public static JSInvocation windowResizeBy() {
        return JSHtml.window().invoke("resizeBy");
    }

    @Nonnull
    public static JSInvocation windowResizeTo() {
        return JSHtml.window().invoke("resizeTo");
    }

    @Nonnull
    public static JSFieldRef windowScreen() {
        return JSHtml.window().ref("screen");
    }

    @Nonnull
    public static JSFieldRef windowScreenLeft() {
        return JSHtml.window().ref("screenLeft");
    }

    @Nonnull
    public static JSFieldRef windowScreenTop() {
        return JSHtml.window().ref("screenTop");
    }

    @Nonnull
    public static JSFieldRef windowScreenX() {
        return JSHtml.window().ref("screenX");
    }

    @Nonnull
    public static JSFieldRef windowScreenY() {
        return JSHtml.window().ref("screenY");
    }

    @Nonnull
    public static JSInvocation windowScroll() {
        return JSHtml.window().invoke("scroll");
    }

    @Nonnull
    public static JSInvocation windowScrollBy() {
        return JSHtml.window().invoke("scrollBy");
    }

    @Nonnull
    public static JSInvocation windowScrollTo() {
        return JSHtml.window().invoke("scrollTo");
    }

    @Nonnull
    public static JSFieldRef windowSelf() {
        return JSHtml.window().ref("self");
    }

    @Nonnull
    public static JSInvocation windowSetInterval() {
        return JSHtml.window().invoke("setInterval");
    }

    @Nonnull
    public static JSInvocation windowSetInterval(@Nonnull JSAnonymousFunction jSAnonymousFunction, @Nonnegative int n) {
        return (JSInvocation)((JSInvocation)JSHtml.windowSetInterval().arg(jSAnonymousFunction)).arg(n);
    }

    @Nonnull
    public static JSInvocation windowSetTimeout() {
        return JSHtml.window().invoke("setTimeout");
    }

    @Nonnull
    public static JSInvocation windowSetTimeout(@Nonnull JSAnonymousFunction jSAnonymousFunction, @Nonnegative int n) {
        return (JSInvocation)((JSInvocation)JSHtml.windowSetTimeout().arg(jSAnonymousFunction)).arg(n);
    }

    @Nonnull
    public static JSFieldRef windowStatus() {
        return JSHtml.window().ref("status");
    }

    @Nonnull
    public static JSFieldRef windowTop() {
        return JSHtml.window().ref("top");
    }

    @Nonnull
    public static JSFieldRef windowOnbeforeunload() {
        return JSHtml.window().ref("onbeforeunload");
    }

    @Nonnull
    public static JSAssignment windowOnbeforeunload(@Nonnull JSAnonymousFunction jSAnonymousFunction) {
        return JSHtml.windowOnbeforeunload().assign(jSAnonymousFunction);
    }

    @Nonnull
    public static JSFieldRef getSelectSelectedValue(@Nonnull IJSExpression iJSExpression) {
        return iJSExpression.ref("options").component(iJSExpression.ref("selectedIndex")).ref("value");
    }

    @Nonnull
    public static JSFieldRef getSelectSelectedValue() {
        return JSHtml.getSelectSelectedValue(JSExpr.THIS);
    }
}

