/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSBlock;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSOp;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSWhileLoop
extends AbstractJSStatement {
    private final IJSExpression m_aTest;
    private JSBlock m_aBody;

    public JSWhileLoop(@Nonnull IJSExpression iJSExpression) {
        this.m_aTest = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Test");
    }

    @Nonnull
    public IJSExpression test() {
        return this.m_aTest;
    }

    @Nonnull
    public JSBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JSBlock();
        }
        return this.m_aBody;
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        if (JSOp.hasOperator(this.m_aTest)) {
            jSFormatter.plain("while").generatable(this.m_aTest);
        } else {
            jSFormatter.plain("while(").generatable(this.m_aTest).plain(')');
        }
        if (this.m_aBody != null) {
            jSFormatter.stmt(this.m_aBody);
        } else {
            jSFormatter.plain(';').nl();
        }
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSWhileLoop jSWhileLoop = (JSWhileLoop)object;
        return this.m_aTest.equals(jSWhileLoop.m_aTest) && EqualsHelper.equals((Object)this.m_aBody, (Object)jSWhileLoop.m_aBody);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aTest).append((Object)this.m_aBody).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("test", (Object)this.m_aTest).append("body", (Object)this.m_aBody).getToString();
    }
}

