/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.JSBlock;
import com.helger.html.jscode.JSCatchBlock;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSTryBlock
extends AbstractJSStatement {
    private final JSBlock m_aBody = new JSBlock();
    private JSCatchBlock m_aCatch;
    private JSBlock m_aFinally;

    @Nonnull
    public JSBlock body() {
        return this.m_aBody;
    }

    @Nonnull
    @CodingStyleguideUnaware
    public JSCatchBlock _catch() {
        if (this.m_aCatch == null) {
            this.m_aCatch = new JSCatchBlock();
        }
        return this.m_aCatch;
    }

    @Nonnull
    @CodingStyleguideUnaware
    public JSCatchBlock _catch(@Nonnull @Nonempty String string) {
        if (this.m_aCatch == null) {
            this.m_aCatch = new JSCatchBlock(string);
        }
        return this.m_aCatch;
    }

    public boolean hasCatch() {
        return this.m_aCatch != null;
    }

    @Nonnull
    @CodingStyleguideUnaware
    public JSBlock _finally() {
        if (this.m_aFinally == null) {
            this.m_aFinally = new JSBlock();
        }
        return this.m_aFinally;
    }

    public boolean hasFinally() {
        return this.m_aFinally != null;
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        if (this.m_aCatch == null && this.m_aFinally == null) {
            jSFormatter.generatable(this.m_aBody);
        } else {
            jSFormatter.plain("try").generatable(this.m_aBody);
            if (this.m_aCatch != null) {
                jSFormatter.generatable(this.m_aCatch);
            }
            if (this.m_aFinally != null) {
                jSFormatter.plain("finally").generatable(this.m_aFinally);
            }
            jSFormatter.nl();
        }
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSTryBlock jSTryBlock = (JSTryBlock)object;
        return EqualsHelper.equals((Object)this.m_aBody, (Object)jSTryBlock.m_aBody) && EqualsHelper.equals((Object)this.m_aCatch, (Object)jSTryBlock.m_aCatch) && EqualsHelper.equals((Object)this.m_aFinally, (Object)jSTryBlock.m_aFinally);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aBody).append((Object)this.m_aCatch).append((Object)this.m_aFinally).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("body", (Object)this.m_aBody).append("catch", (Object)this.m_aCatch).append("finally", (Object)this.m_aFinally).getToString();
    }
}

