/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSThrow
extends AbstractJSStatement {
    private final IJSExpression m_aExpr;

    public JSThrow(@Nonnull IJSExpression iJSExpression) {
        this.m_aExpr = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Expr");
    }

    @Nonnull
    public IJSExpression expr() {
        return this.m_aExpr;
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain("throw ").generatable(this.m_aExpr).plain(';').nl();
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSThrow jSThrow = (JSThrow)object;
        return this.m_aExpr.equals(jSThrow.m_aExpr);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aExpr).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("expr", (Object)this.m_aExpr).getToString();
    }
}

