/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingStringWriter;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.IJSDeclaration;
import com.helger.html.jscode.IJSGeneratable;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSPackage;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;

@Immutable
public final class JSPrinter {
    private JSPrinter() {
    }

    public static void writeGeneratable(@Nonnull @WillClose Writer writer, @Nullable IJSWriterSettings iJSWriterSettings, @Nonnull IJSGeneratable iJSGeneratable) {
        ValueEnforcer.notNull((Object)iJSGeneratable, (String)"Generatable");
        try (JSFormatter jSFormatter = new JSFormatter(writer, iJSWriterSettings);){
            jSFormatter.generatable(iJSGeneratable);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void writeDeclaration(@Nonnull @WillClose Writer writer, @Nullable IJSWriterSettings iJSWriterSettings, @Nonnull IJSDeclaration iJSDeclaration) {
        ValueEnforcer.notNull((Object)iJSDeclaration, (String)"Declaration");
        try (JSFormatter jSFormatter = new JSFormatter(writer, iJSWriterSettings);){
            jSFormatter.decl(iJSDeclaration);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void writeStatement(@Nonnull @WillClose Writer writer, @Nullable IJSWriterSettings iJSWriterSettings, @Nonnull IJSStatement iJSStatement) {
        ValueEnforcer.notNull((Object)iJSStatement, (String)"Statement");
        try (JSFormatter jSFormatter = new JSFormatter(writer, iJSWriterSettings);){
            jSFormatter.stmt(iJSStatement);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void writePackage(@Nonnull @WillClose Writer writer, @Nullable IJSWriterSettings iJSWriterSettings, @Nonnull JSPackage jSPackage) {
        ValueEnforcer.notNull((Object)jSPackage, (String)"Package");
        try (JSFormatter jSFormatter = new JSFormatter(writer, iJSWriterSettings);){
            jSFormatter.pkg(jSPackage);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Nonnull
    public static String getAsString(@Nullable IJSWriterSettings iJSWriterSettings, @Nonnull IJSGeneratable iJSGeneratable) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        JSPrinter.writeGeneratable((Writer)nonBlockingStringWriter, iJSWriterSettings, iJSGeneratable);
        return nonBlockingStringWriter.getAsString().trim();
    }

    @Nonnull
    public static String getAsString(@Nullable IJSWriterSettings iJSWriterSettings, @Nonnull IJSDeclaration iJSDeclaration) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        JSPrinter.writeDeclaration((Writer)nonBlockingStringWriter, iJSWriterSettings, iJSDeclaration);
        return nonBlockingStringWriter.getAsString().trim();
    }

    @Nonnull
    public static String getAsString(@Nullable IJSWriterSettings iJSWriterSettings, @Nonnull IJSStatement iJSStatement) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        JSPrinter.writeStatement((Writer)nonBlockingStringWriter, iJSWriterSettings, iJSStatement);
        return nonBlockingStringWriter.getAsString().trim();
    }

    @Nonnull
    public static String getAsString(@Nullable IJSWriterSettings iJSWriterSettings, @Nonnull JSPackage jSPackage) {
        ValueEnforcer.notNull((Object)jSPackage, (String)"Package");
        if (jSPackage.memberCount() == 0) {
            return "";
        }
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        JSPrinter.writePackage((Writer)nonBlockingStringWriter, iJSWriterSettings, jSPackage);
        return nonBlockingStringWriter.getAsString().trim();
    }
}

