/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;

@Immutable
public class JSOpUnary
extends AbstractJSExpression {
    private final String m_sOp;
    private final IJSExpression m_aExpr;
    private final boolean m_bOpFirst;

    public JSOpUnary(@Nonnull @Nonempty String string, @Nonnull IJSExpression iJSExpression) {
        this(string, iJSExpression, true);
    }

    public JSOpUnary(@Nonnull IJSExpression iJSExpression, @Nonnull @Nonempty String string) {
        this(string, iJSExpression, false);
    }

    private JSOpUnary(@Nonnull String string, @Nonnull IJSExpression iJSExpression, boolean bl) {
        this.m_sOp = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Operator");
        this.m_aExpr = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Expr");
        this.m_bOpFirst = bl;
    }

    @Nonnull
    @Nonempty
    public String operator() {
        return this.m_sOp;
    }

    @Nonnull
    public IJSExpression expr() {
        return this.m_aExpr;
    }

    public boolean isOperatorFirst() {
        return this.m_bOpFirst;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        if (this.m_bOpFirst) {
            jSFormatter.plain(this.m_sOp).generatable(this.m_aExpr);
        } else {
            jSFormatter.generatable(this.m_aExpr).plain(this.m_sOp);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSOpUnary jSOpUnary = (JSOpUnary)object;
        return this.m_sOp.equals(jSOpUnary.m_sOp) && this.m_aExpr.equals(jSOpUnary.m_aExpr) && this.m_bOpFirst == jSOpUnary.m_bOpFirst;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_sOp).append((Object)this.m_aExpr).append(this.m_bOpFirst).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("op", (Object)this.m_sOp).append("expr", (Object)this.m_aExpr).append("opFirst", this.m_bOpFirst).getToString();
    }
}

