/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.JSMarshaller;
import com.helger.html.jscode.JSDefinedClass;
import com.helger.html.jscode.JSFunction;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSMethod
extends JSFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSMethod.class);
    private final JSDefinedClass m_aOwnerClass;

    public JSMethod(@Nonnull JSDefinedClass jSDefinedClass, @Nonnull @Nonempty String string) {
        super(string);
        ValueEnforcer.notNull((Object)jSDefinedClass, (String)"OwnerClass");
        if (!JSMarshaller.isJSIdentifier((String)string)) {
            throw new IllegalArgumentException("The name '" + string + "' is not a legal JS identifier!");
        }
        if (string.equals(jSDefinedClass.name())) {
            throw new IllegalArgumentException("You cannot name a method like the constructor!");
        }
        if (!Character.isLowerCase(string.charAt(0))) {
            LOGGER.warn("Method names should always start with a lowercase character: '" + string + "'");
        }
        this.m_aOwnerClass = jSDefinedClass;
        this.body().newlineAtEnd(false);
    }

    @Nonnull
    public JSDefinedClass parentClass() {
        return this.m_aOwnerClass;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSMethod jSMethod = (JSMethod)object;
        return this.m_aOwnerClass.name().equals(jSMethod.m_aOwnerClass.name());
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aOwnerClass.name()).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("ownerClass", (Object)this.m_aOwnerClass.name()).getToString();
    }
}

