/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSLabel
extends AbstractJSStatement {
    private final String m_sLabel;

    public JSLabel(@Nonnull @Nonempty String string) {
        this.m_sLabel = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Label");
    }

    @Nonnull
    @Nonempty
    public String label() {
        return this.m_sLabel;
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain(this.m_sLabel).plain(':').nl();
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSLabel jSLabel = (JSLabel)object;
        return this.m_sLabel.equals(jSLabel.m_sLabel);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sLabel).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("label", (Object)this.m_sLabel).getToString();
    }
}

