/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.js.JSMarshaller;
import com.helger.html.jscode.IJSDeclaration;
import com.helger.html.jscode.IJSDocCommentable;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSBlock;
import com.helger.html.jscode.JSCommentMultiLine;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.jscode.JSParam;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSFunction
implements IJSDocCommentable,
IJSDeclaration {
    private JSCommentMultiLine m_aJSDoc;
    private String m_sName;
    private final ICommonsList<JSParam> m_aParams = new CommonsArrayList();
    private JSBlock m_aBody;

    public JSFunction(@Nonnull @Nonempty String string) {
        if (!JSMarshaller.isJSIdentifier((String)string)) {
            throw new IllegalArgumentException("The name '" + string + "' is not a legal JS identifier!");
        }
        this.m_sName = string;
    }

    @Override
    @Nonnull
    public String name() {
        return this.m_sName;
    }

    @Nonnull
    public JSFunction name(@Nonnull @Nonempty String string) {
        if (!JSMarshaller.isJSIdentifier((String)string)) {
            throw new IllegalArgumentException("The name '" + string + "' is not a legal JS identifier!");
        }
        this.m_sName = string;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<JSParam> params() {
        return (ICommonsList)this.m_aParams.getClone();
    }

    @Nonnull
    public JSParam param(@Nonnull @Nonempty String string) {
        JSParam jSParam = new JSParam(string);
        this.m_aParams.add((Object)jSParam);
        return jSParam;
    }

    @Nonnegative
    public int getParamCount() {
        return this.m_aParams.size();
    }

    @Nullable
    public JSParam getParamAtIndex(int n) {
        return (JSParam)this.m_aParams.getAtIndex(n);
    }

    @Nonnull
    public JSFunction removeAllParams() {
        this.m_aParams.clear();
        return this;
    }

    @Nonnull
    public JSBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JSBlock();
        }
        return this.m_aBody;
    }

    @Override
    @Nonnull
    public JSCommentMultiLine jsDoc() {
        if (this.m_aJSDoc == null) {
            this.m_aJSDoc = new JSCommentMultiLine();
        }
        return this.m_aJSDoc;
    }

    @Nonnull
    public JSInvocation invoke() {
        return new JSInvocation(this);
    }

    @Nonnull
    public JSAnonymousFunction getAsAnonymousFunction() {
        return new JSAnonymousFunction((Iterable<? extends JSParam>)this.params(), this.body());
    }

    @Override
    public void declare(@Nonnull JSFormatter jSFormatter) {
        if (this.m_aJSDoc != null) {
            jSFormatter.generatable(this.m_aJSDoc);
        }
        jSFormatter.plain("function ").plain(this.m_sName).plain('(');
        boolean bl = true;
        for (JSParam jSParam : this.m_aParams) {
            if (bl) {
                bl = false;
            } else {
                jSFormatter.plain(',');
            }
            jSFormatter.variable(jSParam);
        }
        jSFormatter.plain(')').stmt(this.body());
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSFunction jSFunction = (JSFunction)object;
        return EqualsHelper.equals((Object)this.m_aJSDoc, (Object)jSFunction.m_aJSDoc) && this.m_sName.equals(jSFunction.m_sName) && this.m_aParams.equals(jSFunction.m_aParams) && EqualsHelper.equals((Object)this.m_aBody, (Object)jSFunction.m_aBody);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aJSDoc).append((Object)this.m_sName).append(this.m_aParams).append((Object)this.m_aBody).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("JSDoc", (Object)this.m_aJSDoc).append("Name", (Object)this.m_sName).appendIf("Params", this.m_aParams, CollectionHelper::isNotEmpty).appendIfNotNull("Body", (Object)this.m_aBody).getToString();
    }
}

