/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.AbstractJSType;
import com.helger.html.jscode.AbstractJSVariable;
import com.helger.html.jscode.IJSAssignmentTarget;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSGeneratable;
import com.helger.html.jscode.JSArray;
import com.helger.html.jscode.JSArrayCompRef;
import com.helger.html.jscode.JSAssignment;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSAtom;
import com.helger.html.jscode.JSAtomBigDecimal;
import com.helger.html.jscode.JSAtomBoolean;
import com.helger.html.jscode.JSAtomDecimal;
import com.helger.html.jscode.JSAtomInt;
import com.helger.html.jscode.JSCast;
import com.helger.html.jscode.JSExprDirect;
import com.helger.html.jscode.JSFieldRef;
import com.helger.html.jscode.JSFunction;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.jscode.JSMethod;
import com.helger.html.jscode.JSRef;
import com.helger.html.jscode.JSRegExLiteral;
import com.helger.html.jscode.JSStringLiteral;
import com.helger.html.jscode.type.JSPrimitiveTypes;
import com.helger.json.IJson;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

@Immutable
public final class JSExpr {
    public static final IJSExpression THIS = new JSAtom("this");
    public static final IJSExpression NULL = new JSAtom("null");
    public static final JSAtomBoolean TRUE = new JSAtomBoolean(true);
    public static final JSAtomBoolean FALSE = new JSAtomBoolean(false);
    public static final JSAtom UNDEFINED = new JSAtom("undefined");
    public static final JSStringLiteral UNDEFINED_STR = new JSStringLiteral("undefined");
    private static final int MAX_ATOM_INT_CACHE = 256;
    private static final JSAtomInt[] INT_CACHE = new JSAtomInt[256];
    private static final JSExpr INSTANCE;

    private JSExpr() {
    }

    @Nonnull
    public static JSAssignment assign(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull String string) {
        return JSExpr.assign(iJSAssignmentTarget, JSExpr.lit(string));
    }

    @Nonnull
    public static JSAssignment assign(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull IJSExpression iJSExpression) {
        return new JSAssignment(iJSAssignmentTarget, "=", iJSExpression);
    }

    @Nonnull
    public static JSAssignment assignPlus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull IJSExpression iJSExpression) {
        return new JSAssignment(iJSAssignmentTarget, "+=", iJSExpression);
    }

    @Nonnull
    public static JSAssignment assignMinus(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull IJSExpression iJSExpression) {
        return new JSAssignment(iJSAssignmentTarget, "-=", iJSExpression);
    }

    @Nonnull
    public static JSAssignment assignMultiply(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull IJSExpression iJSExpression) {
        return new JSAssignment(iJSAssignmentTarget, "*=", iJSExpression);
    }

    @Nonnull
    public static JSAssignment assignDivide(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull IJSExpression iJSExpression) {
        return new JSAssignment(iJSAssignmentTarget, "/=", iJSExpression);
    }

    @Nonnull
    public static JSAssignment assignModulo(@Nonnull IJSAssignmentTarget iJSAssignmentTarget, @Nonnull IJSExpression iJSExpression) {
        return new JSAssignment(iJSAssignmentTarget, "%=", iJSExpression);
    }

    @Nonnull
    @CodingStyleguideUnaware
    public static JSInvocation _new(@Nonnull AbstractJSType abstractJSType) {
        return new JSInvocation(abstractJSType);
    }

    @Nonnull
    public static JSInvocation invoke(@Nonnull AbstractJSVariable<?> abstractJSVariable) {
        return new JSInvocation((IJSExpression)null, abstractJSVariable.name());
    }

    @Nonnull
    public static JSInvocation invoke(@Nonnull @Nonempty String string) {
        return new JSInvocation((IJSExpression)null, string);
    }

    @Nonnull
    public static JSInvocation invoke(@Nonnull JSMethod jSMethod) {
        return new JSInvocation((IJSExpression)null, jSMethod);
    }

    @Nonnull
    public static JSInvocation invoke(@Nullable IJSExpression iJSExpression, @Nonnull @Nonempty String string) {
        return new JSInvocation(iJSExpression, string);
    }

    @Nonnull
    public static JSInvocation invoke(@Nullable IJSExpression iJSExpression, @Nonnull JSMethod jSMethod) {
        return new JSInvocation(iJSExpression, jSMethod);
    }

    @Nonnull
    public static JSInvocation invokeThis(@Nonnull @Nonempty String string) {
        return JSExpr.invoke(THIS, string);
    }

    @Nonnull
    public static JSInvocation invokeThis(@Nonnull JSMethod jSMethod) {
        return JSExpr.invoke(THIS, jSMethod);
    }

    @Nonnull
    public static JSRef ref(@Nonnull @Nonempty String string) {
        return new JSRef(string);
    }

    @Nonnull
    public static JSRef ref(@Nonnull @Nonempty JSFunction jSFunction) {
        return new JSRef(jSFunction.name());
    }

    @Nonnull
    public static JSFieldRef ref(@Nonnull IJSExpression iJSExpression, @Nonnull AbstractJSVariable<?> abstractJSVariable) {
        return new JSFieldRef((IJSGeneratable)iJSExpression, abstractJSVariable);
    }

    @Nonnull
    public static JSFieldRef ref(@Nonnull IJSExpression iJSExpression, @Nonnull String string) {
        return new JSFieldRef((IJSGeneratable)iJSExpression, string);
    }

    @Nonnull
    public static JSFieldRef ref(@Nonnull IJSExpression iJSExpression, String ... stringArray) {
        if (ArrayHelper.isEmpty((Object[])stringArray)) {
            throw new IllegalArgumentException("Fields may not be empty");
        }
        JSFieldRef jSFieldRef = new JSFieldRef((IJSGeneratable)iJSExpression, stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            jSFieldRef = new JSFieldRef((IJSGeneratable)jSFieldRef, stringArray[i]);
        }
        return jSFieldRef;
    }

    @Nonnull
    public static JSFieldRef refThis(@Nonnull AbstractJSVariable<?> abstractJSVariable) {
        return JSExpr.ref(THIS, abstractJSVariable);
    }

    @Nonnull
    public static JSFieldRef refThis(@Nonnull String string) {
        return JSExpr.ref(THIS, string);
    }

    @Nonnull
    public static JSFieldRef refThis(String ... stringArray) {
        return JSExpr.ref(THIS, stringArray);
    }

    @Nonnull
    public static JSArrayCompRef component(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        return new JSArrayCompRef(iJSExpression, iJSExpression2);
    }

    @Nonnull
    public static JSCast cast(@Nonnull AbstractJSType abstractJSType, @Nonnull IJSExpression iJSExpression) {
        return new JSCast(abstractJSType, iJSExpression);
    }

    @Nonnull
    public static JSAtomBoolean lit(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    @Nonnull
    public static JSAtomInt lit(int n) {
        return n >= 0 && n < 256 ? INT_CACHE[n] : new JSAtomInt(n);
    }

    @Nonnull
    public static JSAtomInt lit(long l) {
        return l >= 0L && l < 256L ? INT_CACHE[(int)l] : new JSAtomInt(l);
    }

    @Nonnull
    public static JSAtom lit(@Nonnull BigInteger bigInteger) {
        return new JSAtom(bigInteger.toString());
    }

    @Nonnull
    public static AbstractJSExpression lit(float f) {
        if (Float.isNaN(f)) {
            return JSPrimitiveTypes.NUMBER.nan();
        }
        return new JSAtomDecimal(f);
    }

    @Nonnull
    public static AbstractJSExpression lit(double d) {
        if (Double.isNaN(d)) {
            return JSPrimitiveTypes.NUMBER.nan();
        }
        return new JSAtomDecimal(d);
    }

    @Nonnull
    public static JSAtomBigDecimal lit(@Nonnull BigDecimal bigDecimal) {
        return new JSAtomBigDecimal(bigDecimal);
    }

    @Nonnull
    public static JSStringLiteral lit(char c) {
        return new JSStringLiteral(Character.toString(c));
    }

    @Nonnull
    public static JSStringLiteral lit(@Nonnull String string) {
        return new JSStringLiteral(string);
    }

    @Nonnull
    public static IJSExpression convert(@Nullable Object object) {
        if (object == null) {
            return NULL;
        }
        if (object instanceof IJSExpression) {
            return (IJSExpression)object;
        }
        if (object instanceof String) {
            return JSExpr.lit((String)object);
        }
        if (object instanceof BigInteger) {
            return JSExpr.lit((BigInteger)object);
        }
        if (object instanceof BigDecimal) {
            return JSExpr.lit((BigDecimal)object);
        }
        if (object instanceof Boolean) {
            return JSExpr.lit((Boolean)object);
        }
        if (object instanceof Character) {
            return JSExpr.lit(((Character)object).charValue());
        }
        if (object instanceof Double) {
            return JSExpr.lit((Double)object);
        }
        if (object instanceof Float) {
            return JSExpr.lit(((Float)object).floatValue());
        }
        if (object instanceof Long) {
            return JSExpr.lit((Long)object);
        }
        if (object instanceof Number) {
            return JSExpr.lit(((Number)object).intValue());
        }
        throw new IllegalArgumentException("Cannot convert object of class " + String.valueOf(object.getClass()) + " to IJSExpression!");
    }

    @Nonnull
    public static JSRegExLiteral regex(@Nonnull String string) {
        return new JSRegExLiteral(string);
    }

    @Nonnull
    public static IJSExpression json(@Nonnull IJson iJson) {
        ValueEnforcer.notNull((Object)iJson, (String)"Json");
        if (iJson.isObject()) {
            JSAssocArray jSAssocArray = new JSAssocArray();
            for (Map.Entry entry : iJson.getAsObject()) {
                jSAssocArray.add((String)entry.getKey(), JSExpr.json((IJson)entry.getValue()));
            }
            return jSAssocArray;
        }
        if (iJson.isArray()) {
            JSArray jSArray = new JSArray();
            for (IJson iJson2 : iJson.getAsArray()) {
                jSArray.add(JSExpr.json(iJson2));
            }
            return jSArray;
        }
        return JSExpr.convert(iJson.getAsValue().getValue());
    }

    @Nonnull
    public static JSExprDirect direct(@Nonnull String string) {
        return new JSExprDirect(string);
    }

    static {
        for (int i = 0; i < INT_CACHE.length; ++i) {
            JSExpr.INT_CACHE[i] = new JSAtomInt(i);
        }
        INSTANCE = new JSExpr();
    }
}

