/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.js.JSMarshaller;
import com.helger.html.jscode.AbstractJSClass;
import com.helger.html.jscode.AbstractJSVariable;
import com.helger.html.jscode.IJSAssignmentTarget;
import com.helger.html.jscode.IJSDeclaration;
import com.helger.html.jscode.IJSDocCommentable;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSCommentMultiLine;
import com.helger.html.jscode.JSConstructor;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSFieldRef;
import com.helger.html.jscode.JSFieldVar;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSFunction;
import com.helger.html.jscode.JSMethod;
import com.helger.html.jscode.JSNameAlreadyExistsException;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSDefinedClass
extends AbstractJSClass
implements IJSDeclaration,
IJSDocCommentable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSDefinedClass.class);
    private JSCommentMultiLine m_aJSDoc;
    private final String m_sName;
    private AbstractJSClass m_aSuperClass;
    private final ICommonsOrderedMap<String, JSFieldVar> m_aFields = new CommonsLinkedHashMap();
    private JSConstructor m_aConstructor;
    private final ICommonsList<JSMethod> m_aMethods = new CommonsArrayList();

    public JSDefinedClass(@Nonnull @Nonempty String string) {
        if (!JSMarshaller.isJSIdentifier((String)string)) {
            throw new IllegalArgumentException("The name '" + string + "' is not a legal JS identifier!");
        }
        if (!Character.isUpperCase(string.charAt(0))) {
            LOGGER.warn("Class names should always start with an upper-case character: " + string);
        }
        this.m_sName = string;
    }

    @Nonnull
    @CodingStyleguideUnaware
    public JSDefinedClass _extends(@Nonnull AbstractJSClass abstractJSClass) {
        this.m_aSuperClass = (AbstractJSClass)ValueEnforcer.notNull((Object)abstractJSClass, (String)"SuperClass");
        return this;
    }

    @Override
    @Nullable
    @CodingStyleguideUnaware
    public AbstractJSClass _extends() {
        return this.m_aSuperClass;
    }

    @Override
    @Nonnull
    @Nonempty
    public String name() {
        return this.m_sName;
    }

    @Nonnull
    public JSFieldVar field(@Nonnull @Nonempty String string) {
        return this.field(string, null);
    }

    @Nonnull
    public JSFieldVar field(@Nonnull @Nonempty String string, @Nullable IJSExpression iJSExpression) {
        JSFieldVar jSFieldVar = new JSFieldVar(this, string, iJSExpression);
        return this.addField(jSFieldVar);
    }

    @Nullable
    public JSFieldVar getFieldOfName(@Nullable String string) {
        return (JSFieldVar)this.m_aFields.get((Object)string);
    }

    @Nonnull
    public JSFieldVar addField(@Nonnull JSFieldVar jSFieldVar) {
        ValueEnforcer.notNull((Object)jSFieldVar, (String)"Field");
        String string = jSFieldVar.name();
        JSFieldVar jSFieldVar2 = this.getFieldOfName(string);
        if (jSFieldVar2 != null) {
            throw new JSNameAlreadyExistsException(jSFieldVar2);
        }
        this.m_aFields.put((Object)string, (Object)jSFieldVar);
        return jSFieldVar;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, JSFieldVar> fields() {
        return this.m_aFields.getClone();
    }

    public boolean containsField(@Nullable String string) {
        return this.m_aFields.containsKey((Object)string);
    }

    @Nonnull
    public JSDefinedClass removeField(@Nonnull JSFieldVar jSFieldVar) {
        ValueEnforcer.notNull((Object)jSFieldVar, (String)"Field");
        if (this.m_aFields.remove((Object)jSFieldVar.name()) != jSFieldVar) {
            throw new IllegalArgumentException("Failed to remove field '" + jSFieldVar.name() + "' from " + String.valueOf(this.m_aFields.keySet()));
        }
        return this;
    }

    @Nonnull
    public JSDefinedClass removeAllFields() {
        this.m_aFields.clear();
        return this;
    }

    @Nonnull
    public JSConstructor constructor() {
        if (this.m_aConstructor == null) {
            this.m_aConstructor = new JSConstructor(this);
        }
        return this.m_aConstructor;
    }

    @Nonnull
    public JSMethod method(@Nonnull @Nonempty String string) {
        JSMethod jSMethod = new JSMethod(this, string);
        this.m_aMethods.add((Object)jSMethod);
        return jSMethod;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<JSMethod> methods() {
        return (ICommonsList)this.m_aMethods.getClone();
    }

    @Override
    @Nonnull
    public JSCommentMultiLine jsDoc() {
        if (this.m_aJSDoc == null) {
            this.m_aJSDoc = new JSCommentMultiLine();
        }
        return this.m_aJSDoc;
    }

    @Nonnull
    public JSFieldRef prototype() {
        return this.staticRef("prototype");
    }

    @Override
    public void declare(@Nonnull JSFormatter jSFormatter) {
        if (this.m_aJSDoc != null) {
            jSFormatter.nl().generatable(this.m_aJSDoc);
        }
        jSFormatter.decl(this.constructor());
        JSAssocArray jSAssocArray = new JSAssocArray();
        for (IJSDeclaration iJSDeclaration : this.m_aFields.values()) {
            jSAssocArray.add(((AbstractJSVariable)iJSDeclaration).name(), ((AbstractJSVariable)iJSDeclaration).hasInit() ? ((AbstractJSVariable)iJSDeclaration).init() : JSExpr.NULL);
        }
        for (IJSDeclaration iJSDeclaration : this.m_aMethods) {
            jSAssocArray.add(((JSFunction)iJSDeclaration).name(), (IJSExpression)((JSFunction)iJSDeclaration).getAsAnonymousFunction());
        }
        JSExpr.assign((IJSAssignmentTarget)this.prototype(), jSAssocArray).generate(jSFormatter);
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSDefinedClass jSDefinedClass = (JSDefinedClass)object;
        return EqualsHelper.equals((Object)this.m_aJSDoc, (Object)jSDefinedClass.m_aJSDoc) && this.m_sName.equals(jSDefinedClass.m_sName) && EqualsHelper.equals((Object)this.m_aSuperClass, (Object)jSDefinedClass.m_aSuperClass) && this.m_aFields.equals(jSDefinedClass.m_aFields) && EqualsHelper.equals((Object)this.m_aConstructor, (Object)jSDefinedClass.m_aConstructor) && this.m_aMethods.equals(jSDefinedClass.m_aMethods);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aJSDoc).append((Object)this.m_sName).append((Object)this.m_aSuperClass).append(this.m_aFields).append((Object)this.m_aConstructor).append(this.m_aMethods).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("jsDoc", (Object)this.m_aJSDoc).append("name", (Object)this.m_sName).appendIfNotNull("superClass", (Object)this.m_aSuperClass).append("fields", this.m_aFields).appendIfNotNull("constructor", (Object)this.m_aConstructor).append("methods", this.m_aMethods).getToString();
    }
}

