/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.html.jscode.AbstractJSClass;
import com.helger.html.jscode.AbstractJSType;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;

public class JSCommentPart
extends CommonsArrayList<Object> {
    public JSCommentPart append(@Nullable Object object) {
        this.add(object);
        return this;
    }

    public boolean add(@Nullable Object object) {
        this._flattenAppend(object);
        return true;
    }

    private void _flattenAppend(@Nullable Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                this._flattenAppend(object2);
            }
        } else if (object instanceof Iterable) {
            for (Object t : (Iterable)object) {
                this._flattenAppend(t);
            }
        } else {
            super.add(object);
        }
    }

    protected void format(@Nonnull JSFormatter jSFormatter, @Nonnull String string) {
        if (!this.isEmpty()) {
            jSFormatter.plain(string);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof String) {
                int n;
                String string2 = (String)e;
                while ((n = string2.indexOf(10)) != -1) {
                    String string3 = string2.substring(0, n);
                    if (string3.length() > 0) {
                        jSFormatter.plain(JSCommentPart._escape(string3));
                    }
                    string2 = string2.substring(n + 1);
                    jSFormatter.nlFix().plain(string);
                }
                if (string2.length() == 0) continue;
                jSFormatter.plain(JSCommentPart._escape(string2));
                continue;
            }
            if (e instanceof AbstractJSClass) {
                ((AbstractJSClass)e).printLink(jSFormatter);
                continue;
            }
            if (e instanceof AbstractJSType) {
                jSFormatter.generatable((AbstractJSType)e);
                continue;
            }
            throw new IllegalStateException("Unsupported value: " + String.valueOf(e));
        }
        if (!this.isEmpty()) {
            jSFormatter.nlFix();
        }
    }

    @Nonnull
    private static String _escape(@Nonnull String string) {
        Object object = string;
        int n;
        while ((n = ((String)object).indexOf("*/")) >= 0) {
            object = ((String)object).substring(0, n + 1) + "<!-- -->" + ((String)object).substring(n + 1);
        }
        return object;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !((Object)((Object)this)).getClass().equals(object.getClass())) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("list", (Object)super.toString()).getToString();
    }
}

