/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSVariable;
import com.helger.html.jscode.IJSGeneratable;
import com.helger.html.jscode.JSCommentPart;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

public class JSCommentMultiLine
extends JSCommentPart
implements IJSGeneratable {
    private static final String INDENT = " *     ";
    private final ICommonsOrderedMap<String, JSCommentPart> m_aParams = new CommonsLinkedHashMap();
    private final ICommonsOrderedMap<String, ICommonsMap<String, String>> m_aXDoclets = new CommonsLinkedHashMap();
    private JSCommentPart m_aReturn;
    private JSCommentPart m_aDeprecated;

    @Override
    @Nonnull
    public JSCommentMultiLine append(@Nullable Object object) {
        this.add(object);
        return this;
    }

    @Nonnull
    public JSCommentPart addParam(@Nonnull String string2) {
        ValueEnforcer.notNull((Object)string2, (String)"Param");
        return (JSCommentPart)((Object)this.m_aParams.computeIfAbsent((Object)string2, string -> new JSCommentPart()));
    }

    @Nonnull
    public JSCommentPart addParam(@Nonnull AbstractJSVariable<?> abstractJSVariable) {
        return this.addParam(abstractJSVariable.name());
    }

    @Nonnull
    public JSCommentPart addReturn() {
        if (this.m_aReturn == null) {
            this.m_aReturn = new JSCommentPart();
        }
        return this.m_aReturn;
    }

    @Nonnull
    public JSCommentPart addDeprecated() {
        if (this.m_aDeprecated == null) {
            this.m_aDeprecated = new JSCommentPart();
        }
        return this.m_aDeprecated;
    }

    @Nonnull
    public ICommonsMap<String, String> addXdoclet(@Nonnull String string2) {
        ValueEnforcer.notNull((Object)string2, (String)"Name");
        return (ICommonsMap)this.m_aXDoclets.computeIfAbsent((Object)string2, string -> new CommonsHashMap());
    }

    @Nonnull
    public ICommonsMap<String, String> addXdoclet(@Nonnull String string, @Nonnull Map<String, String> map) {
        ICommonsMap<String, String> iCommonsMap = this.addXdoclet(string);
        iCommonsMap.putAll(map);
        return iCommonsMap;
    }

    @Nonnull
    public ICommonsMap<String, String> addXdoclet(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        ICommonsMap<String, String> iCommonsMap = this.addXdoclet(string);
        iCommonsMap.put((Object)string2, (Object)string3);
        return iCommonsMap;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        if (jSFormatter.getSettings().isGenerateComments()) {
            jSFormatter.plain("/**").nlFix();
            this.format(jSFormatter, " * ");
            if (this.m_aParams.isNotEmpty() || this.m_aReturn != null || this.m_aDeprecated != null || this.m_aXDoclets.isNotEmpty()) {
                jSFormatter.plain(" * ").nlFix();
                for (Map.Entry entry : this.m_aParams.entrySet()) {
                    jSFormatter.plain(" * @param ").plain((String)entry.getKey()).nlFix();
                    ((JSCommentPart)((Object)entry.getValue())).format(jSFormatter, INDENT);
                }
                if (this.m_aReturn != null) {
                    jSFormatter.plain(" * @return").nlFix();
                    this.m_aReturn.format(jSFormatter, INDENT);
                }
                if (this.m_aDeprecated != null) {
                    jSFormatter.plain(" * @deprecated").nlFix();
                    this.m_aDeprecated.format(jSFormatter, INDENT);
                }
                for (Map.Entry entry : this.m_aXDoclets.entrySet()) {
                    jSFormatter.plain(" * @").plain((String)entry.getKey());
                    if (entry.getValue() != null) {
                        for (Map.Entry entry2 : ((ICommonsMap)entry.getValue()).entrySet()) {
                            jSFormatter.plain(" ").plain((String)entry2.getKey()).plain("= \"").plain((String)entry2.getValue()).plain("\"");
                        }
                    }
                    jSFormatter.nlFix();
                }
            }
            jSFormatter.plain(" */").nlFix();
        }
    }

    @Nonnull
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSCommentMultiLine jSCommentMultiLine = (JSCommentMultiLine)object;
        return this.m_aParams.equals(jSCommentMultiLine.m_aParams) && this.m_aXDoclets.equals(jSCommentMultiLine.m_aXDoclets) && EqualsHelper.equals((Object)((Object)this.m_aReturn), (Object)((Object)jSCommentMultiLine.m_aReturn)) && EqualsHelper.equals((Object)((Object)this.m_aDeprecated), (Object)((Object)jSCommentMultiLine.m_aDeprecated));
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aParams).append(this.m_aXDoclets).append((Object)this.m_aReturn).append((Object)this.m_aDeprecated).getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator((Object)this).append("params", this.m_aParams).append("xdoclets", this.m_aXDoclets).append("return", (Object)this.m_aReturn).append("deprecated", (Object)this.m_aDeprecated).getToString();
    }
}

