/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.IJSGeneratable;
import com.helger.html.jscode.JSBlock;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSParam;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSCatchBlock
implements IJSGeneratable {
    public static final String DEFAULT_VAR_NAME = "e";
    private JSParam m_aVar;
    private final JSBlock m_aBody = new JSBlock();

    public JSCatchBlock() {
    }

    public JSCatchBlock(@Nonnull @Nonempty String string) {
        this.m_aVar = new JSParam(string);
    }

    @Nullable
    public JSParam param() {
        return this.m_aVar;
    }

    @Nonnull
    public JSParam param(@Nonnull @Nonempty String string) {
        if (this.m_aVar != null) {
            throw new IllegalStateException("Catch block already has a variable");
        }
        this.m_aVar = new JSParam(string);
        return this.m_aVar;
    }

    @Nonnull
    public JSBlock body() {
        return this.m_aBody;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        if (this.m_aVar == null) {
            this.m_aVar = new JSParam(DEFAULT_VAR_NAME);
        }
        jSFormatter.plain("catch (").variable(this.m_aVar).plain(')').generatable(this.m_aBody);
    }

    @Nonnull
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSCatchBlock jSCatchBlock = (JSCatchBlock)object;
        return this.m_aVar.equals(jSCatchBlock.m_aVar) && this.m_aBody.equals(jSCatchBlock.m_aBody);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aVar).append((Object)this.m_aBody).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Variable", (Object)this.m_aVar).append("Body", (Object)this.m_aBody).getToString();
    }
}

