/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.AbstractJSType;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;

public class JSCast
extends AbstractJSExpression {
    private final AbstractJSType m_aType;
    private final IJSExpression m_aExpr;

    public JSCast(@Nonnull AbstractJSType abstractJSType, @Nonnull IJSExpression iJSExpression) {
        ValueEnforcer.notNull((Object)abstractJSType, (String)"Type");
        ValueEnforcer.notNull((Object)iJSExpression, (String)"Object");
        this.m_aType = abstractJSType;
        this.m_aExpr = iJSExpression;
    }

    @Nonnull
    public AbstractJSType type() {
        return this.m_aType;
    }

    @Nonnull
    public IJSExpression expr() {
        return this.m_aExpr;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain("((").generatable(this.m_aType).plain(')').generatable(this.m_aExpr).plain(')');
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSCast jSCast = (JSCast)object;
        return this.m_aType.equals(jSCast.m_aType) && this.m_aExpr.equals(jSCast.m_aExpr);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aType).append((Object)this.m_aExpr).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("type", (Object)this.m_aType).append("object", (Object)this.m_aExpr).getToString();
    }
}

