/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.AbstractJSStatement;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSLabel;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSBreak
extends AbstractJSStatement {
    private final JSLabel m_aLabel;

    public JSBreak() {
        this(null);
    }

    public JSBreak(@Nullable JSLabel jSLabel) {
        this.m_aLabel = jSLabel;
    }

    @Nullable
    public JSLabel label() {
        return this.m_aLabel;
    }

    public boolean hasLabel() {
        return this.m_aLabel != null;
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        if (this.m_aLabel == null) {
            jSFormatter.plain("break;").nl();
        } else {
            jSFormatter.plain("break ").plain(this.m_aLabel.label()).plain(';').nl();
        }
    }

    @Nullable
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSBreak jSBreak = (JSBreak)object;
        return EqualsHelper.equals((Object)this.m_aLabel, (Object)jSBreak.m_aLabel);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aLabel).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("label", (Object)this.m_aLabel).getToString();
    }
}

