/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.AbstractJSAtomNumeric;
import com.helger.html.jscode.JSAtomDecimal;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;

@Immutable
public class JSAtomInt
extends AbstractJSAtomNumeric {
    private final long m_nValue;

    public JSAtomInt(long l) {
        this.m_nValue = l;
    }

    @Override
    public boolean isDecimalValue() {
        return false;
    }

    @Override
    public double doubleValue() {
        return this.m_nValue;
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericMinus() {
        return new JSAtomInt(-this.m_nValue);
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericIncr() {
        return new JSAtomInt(this.m_nValue + 1L);
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericDecr() {
        return new JSAtomInt(this.m_nValue - 1L);
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericPlus(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        if (abstractJSAtomNumeric.isDecimalValue()) {
            return new JSAtomDecimal((double)this.m_nValue + abstractJSAtomNumeric.doubleValue());
        }
        return new JSAtomInt(this.m_nValue + (long)abstractJSAtomNumeric.doubleValue());
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericMinus(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        if (abstractJSAtomNumeric.isDecimalValue()) {
            return new JSAtomDecimal((double)this.m_nValue - abstractJSAtomNumeric.doubleValue());
        }
        return new JSAtomInt(this.m_nValue - (long)abstractJSAtomNumeric.doubleValue());
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericMul(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        if (abstractJSAtomNumeric.isDecimalValue()) {
            return new JSAtomDecimal((double)this.m_nValue * abstractJSAtomNumeric.doubleValue());
        }
        return new JSAtomInt(this.m_nValue * (long)abstractJSAtomNumeric.doubleValue());
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericDiv(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        return new JSAtomDecimal((double)this.m_nValue / abstractJSAtomNumeric.doubleValue());
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericMod(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        if (abstractJSAtomNumeric.isDecimalValue()) {
            return new JSAtomDecimal((double)this.m_nValue % abstractJSAtomNumeric.doubleValue());
        }
        return new JSAtomInt(this.m_nValue % (long)abstractJSAtomNumeric.doubleValue());
    }

    public long getContainedValue() {
        return this.m_nValue;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain(Long.toString(this.m_nValue));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSAtomInt jSAtomInt = (JSAtomInt)object;
        return EqualsHelper.equals((long)this.m_nValue, (long)jSAtomInt.m_nValue);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_nValue).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("value", this.m_nValue).getToString();
    }
}

