/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;

@Immutable
public class JSAtomBoolean
extends AbstractJSExpression {
    private final boolean m_bValue;

    public JSAtomBoolean(boolean bl) {
        this.m_bValue = bl;
    }

    public boolean getContainedValue() {
        return this.m_bValue;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain(Boolean.toString(this.m_bValue));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSAtomBoolean jSAtomBoolean = (JSAtomBoolean)object;
        return this.m_bValue == jSAtomBoolean.m_bValue;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_bValue).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("value", this.m_bValue).getToString();
    }
}

