/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.AbstractJSAtomNumeric;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;

@Immutable
public class JSAtomBigDecimal
extends AbstractJSAtomNumeric {
    private final BigDecimal m_aValue;

    public JSAtomBigDecimal(@Nonnull BigDecimal bigDecimal) {
        this.m_aValue = (BigDecimal)ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
    }

    @Override
    public boolean isDecimalValue() {
        return true;
    }

    @Override
    public double doubleValue() {
        return this.m_aValue.doubleValue();
    }

    @Override
    @Nonnull
    public JSAtomBigDecimal numericMinus() {
        return new JSAtomBigDecimal(this.m_aValue.negate());
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericIncr() {
        return new JSAtomBigDecimal(this.m_aValue.add(BigDecimal.ONE));
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericDecr() {
        return new JSAtomBigDecimal(this.m_aValue.subtract(BigDecimal.ONE));
    }

    @Nonnull
    private static BigDecimal _getParam(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        return abstractJSAtomNumeric instanceof JSAtomBigDecimal ? ((JSAtomBigDecimal)abstractJSAtomNumeric).getContainedValue() : BigDecimal.valueOf(abstractJSAtomNumeric.doubleValue());
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericPlus(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        BigDecimal bigDecimal = JSAtomBigDecimal._getParam(abstractJSAtomNumeric);
        return new JSAtomBigDecimal(this.m_aValue.add(bigDecimal));
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericMinus(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        BigDecimal bigDecimal = JSAtomBigDecimal._getParam(abstractJSAtomNumeric);
        return new JSAtomBigDecimal(this.m_aValue.subtract(bigDecimal));
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericMul(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        BigDecimal bigDecimal = JSAtomBigDecimal._getParam(abstractJSAtomNumeric);
        return new JSAtomBigDecimal(this.m_aValue.multiply(bigDecimal));
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericDiv(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        BigDecimal bigDecimal = JSAtomBigDecimal._getParam(abstractJSAtomNumeric);
        return new JSAtomBigDecimal(this.m_aValue.divide(bigDecimal));
    }

    @Override
    @Nonnull
    public AbstractJSAtomNumeric numericMod(@Nonnull AbstractJSAtomNumeric abstractJSAtomNumeric) {
        BigDecimal bigDecimal = JSAtomBigDecimal._getParam(abstractJSAtomNumeric);
        return new JSAtomBigDecimal(this.m_aValue.remainder(bigDecimal));
    }

    @Nonnull
    public BigDecimal getContainedValue() {
        return this.m_aValue;
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain(this.m_aValue.toPlainString());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSAtomBigDecimal jSAtomBigDecimal = (JSAtomBigDecimal)object;
        return EqualsHelper.equals((Object)this.m_aValue, (Object)jSAtomBigDecimal.m_aValue);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aValue).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("value", (Object)this.m_aValue).getToString();
    }
}

