/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.jscode.AbstractJSAssignmentTarget;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSFormatter;
import jakarta.annotation.Nonnull;

public class JSArrayCompRef
extends AbstractJSAssignmentTarget {
    private final IJSExpression m_aArray;
    private final IJSExpression m_aIndex;

    JSArrayCompRef(@Nonnull IJSExpression iJSExpression, @Nonnull IJSExpression iJSExpression2) {
        this.m_aArray = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Array");
        this.m_aIndex = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression2, (String)"Index");
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.generatable(this.m_aArray).plain('[').generatable(this.m_aIndex).plain(']');
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSArrayCompRef jSArrayCompRef = (JSArrayCompRef)object;
        return this.m_aArray.equals(jSArrayCompRef.m_aArray) && this.m_aIndex.equals(jSArrayCompRef.m_aIndex);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aArray).append((Object)this.m_aIndex).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("array", (Object)this.m_aArray).append("index", (Object)this.m_aIndex).getToString();
    }
}

