/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.iface.IHasSize;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSGeneratable;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSFormatter;
import com.helger.json.IJson;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JSArray
extends AbstractJSExpression
implements IHasSize {
    private ICommonsList<IJSExpression> m_aExprs;

    @Nonnegative
    public int size() {
        return this.m_aExprs == null ? 0 : this.m_aExprs.size();
    }

    public boolean isEmpty() {
        return this.m_aExprs == null || this.m_aExprs.isEmpty();
    }

    public boolean isNotEmpty() {
        return this.m_aExprs != null && this.m_aExprs.isNotEmpty();
    }

    @Nonnull
    public JSArray add(boolean bl) {
        return this.add(JSExpr.lit(bl));
    }

    @Nonnull
    public JSArray add(char c) {
        return this.add(JSExpr.lit(c));
    }

    @Nonnull
    public JSArray add(double d) {
        return this.add(JSExpr.lit(d));
    }

    @Nonnull
    public JSArray add(float f) {
        return this.add(JSExpr.lit(f));
    }

    @Nonnull
    public JSArray add(int n) {
        return this.add(JSExpr.lit(n));
    }

    @Nonnull
    public JSArray add(long l) {
        return this.add(JSExpr.lit(l));
    }

    @Nonnull
    public JSArray add(@Nullable BigDecimal bigDecimal) {
        return this.add(bigDecimal == null ? JSExpr.NULL : JSExpr.lit(bigDecimal));
    }

    @Nonnull
    public JSArray add(@Nullable BigInteger bigInteger) {
        return this.add(bigInteger == null ? JSExpr.NULL : JSExpr.lit(bigInteger));
    }

    @Nonnull
    public JSArray add(@Nullable String string) {
        return this.add(string == null ? JSExpr.NULL : JSExpr.lit(string));
    }

    @Nonnull
    public JSArray add(@Nullable IJson iJson) {
        return this.add(iJson == null ? JSExpr.NULL : JSExpr.json(iJson));
    }

    @Nonnull
    public JSArray add(@Nullable IHCNode iHCNode) {
        return this.add(iHCNode == null ? null : HCRenderer.getAsHTMLStringWithoutNamespaces((IHCNode)iHCNode));
    }

    @Nonnull
    public JSArray addAll(boolean ... blArray) {
        for (boolean bl : blArray) {
            this.add(bl);
        }
        return this;
    }

    @Nonnull
    public JSArray addAll(char ... cArray) {
        for (char c : cArray) {
            this.add(c);
        }
        return this;
    }

    @Nonnull
    public JSArray addAll(double ... dArray) {
        for (double d : dArray) {
            this.add(d);
        }
        return this;
    }

    @Nonnull
    public JSArray addAll(float ... fArray) {
        for (float f : fArray) {
            this.add(f);
        }
        return this;
    }

    @Nonnull
    public JSArray addAll(int ... nArray) {
        for (int n : nArray) {
            this.add(n);
        }
        return this;
    }

    @Nonnull
    public JSArray addAll(long ... lArray) {
        for (long l : lArray) {
            this.add(l);
        }
        return this;
    }

    @Nonnull
    public JSArray addAll(BigDecimal ... bigDecimalArray) {
        for (BigDecimal bigDecimal : bigDecimalArray) {
            this.add(bigDecimal);
        }
        return this;
    }

    @Nonnull
    public JSArray addAll(BigInteger ... bigIntegerArray) {
        for (BigInteger bigInteger : bigIntegerArray) {
            this.add(bigInteger);
        }
        return this;
    }

    @Nonnull
    public JSArray addAll(String ... stringArray) {
        for (String string : stringArray) {
            this.add(string);
        }
        return this;
    }

    @Nonnull
    public JSArray addAll(@Nonnull Iterable<String> iterable) {
        for (String string : iterable) {
            this.add(string);
        }
        return this;
    }

    @Nonnull
    public JSArray addAllExpr(IJSExpression ... iJSExpressionArray) {
        for (IJSExpression iJSExpression : iJSExpressionArray) {
            this.add(iJSExpression);
        }
        return this;
    }

    @Nonnull
    public JSArray addAllExpr(@Nonnull Iterable<? extends IJSExpression> iterable) {
        for (IJSExpression iJSExpression : iterable) {
            this.add(iJSExpression);
        }
        return this;
    }

    @Nonnull
    public JSArray add(@Nonnull IJSExpression iJSExpression) {
        ValueEnforcer.notNull((Object)iJSExpression, (String)"Expr");
        if (this.m_aExprs == null) {
            this.m_aExprs = new CommonsArrayList();
        }
        this.m_aExprs.add((Object)iJSExpression);
        return this;
    }

    @Nonnull
    public JSArray remove(@Nonnegative int n) {
        if (this.m_aExprs != null) {
            this.m_aExprs.remove(n);
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJSExpression> getAll() {
        return new CommonsArrayList(this.m_aExprs);
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.plain('[');
        if (this.m_aExprs != null) {
            jSFormatter.generatable((Iterable<? extends IJSGeneratable>)this.m_aExprs);
        }
        jSFormatter.plain(']');
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSArray jSArray = (JSArray)object;
        return EqualsHelper.equals(this.m_aExprs, jSArray.m_aExprs);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_aExprs).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("exprs", this.m_aExprs).getToString();
    }
}

