/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSBlock;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.jscode.JSParam;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class JSAnonymousFunction
extends AbstractJSExpression {
    private final ICommonsList<JSParam> m_aParams = new CommonsArrayList();
    private JSBlock m_aBody;

    public JSAnonymousFunction() {
    }

    public JSAnonymousFunction(@Nullable IJSStatement iJSStatement) {
        if (iJSStatement != null) {
            this.body().add(iJSStatement);
        }
    }

    public JSAnonymousFunction(@Nullable JSParam jSParam, @Nullable IJSStatement iJSStatement) {
        if (jSParam != null) {
            this.m_aParams.add((Object)jSParam);
        }
        if (iJSStatement != null) {
            this.body().add(iJSStatement);
        }
    }

    public JSAnonymousFunction(@Nullable Iterable<? extends JSParam> iterable, @Nullable IJSStatement iJSStatement) {
        this.m_aParams.addAll(iterable);
        if (iJSStatement != null) {
            this.body().add(iJSStatement);
        }
    }

    public JSAnonymousFunction(@Nullable JSBlock jSBlock) {
        this.m_aBody = jSBlock;
    }

    public JSAnonymousFunction(@Nullable JSParam jSParam, @Nullable JSBlock jSBlock) {
        if (jSParam != null) {
            this.m_aParams.add((Object)jSParam);
        }
        this.m_aBody = jSBlock;
    }

    public JSAnonymousFunction(@Nullable Iterable<? extends JSParam> iterable, @Nullable JSBlock jSBlock) {
        if (iterable != null) {
            this.m_aParams.addAll(iterable);
        }
        this.m_aBody = jSBlock;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<JSParam> params() {
        return (ICommonsList)this.m_aParams.getClone();
    }

    @Nonnull
    public JSParam param(@Nonnull @Nonempty String string) {
        JSParam jSParam = new JSParam(string);
        this.m_aParams.add((Object)jSParam);
        return jSParam;
    }

    @Nonnull
    public JSParam paramRandomName() {
        return this.param("v" + GlobalIDFactory.getNewIntID());
    }

    @Nonnegative
    public int getParamCount() {
        return this.m_aParams.size();
    }

    @Nullable
    public JSParam getParamAtIndex(int n) {
        return (JSParam)this.m_aParams.getAtIndex(n);
    }

    @Nonnull
    public JSBlock body() {
        if (this.m_aBody == null) {
            this.m_aBody = new JSBlock().newlineAtEnd(false);
        }
        return this.m_aBody;
    }

    @Nonnull
    public JSInvocation invoke() {
        return new JSInvocation(this);
    }

    @Override
    public void generate(JSFormatter jSFormatter) {
        jSFormatter.plain("function").plain('(');
        boolean bl = true;
        for (JSParam jSParam : this.m_aParams) {
            if (bl) {
                bl = false;
            } else {
                jSFormatter.plain(',');
            }
            jSFormatter.variable(jSParam);
        }
        jSFormatter.plain(')').stmt(this.body());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        JSAnonymousFunction jSAnonymousFunction = (JSAnonymousFunction)object;
        return this.m_aParams.equals(jSAnonymousFunction.m_aParams) && EqualsHelper.equals((Object)this.m_aBody, (Object)jSAnonymousFunction.m_aBody);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_aParams).append((Object)this.m_aBody).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIf("Params", this.m_aParams, CollectionHelper::isNotEmpty).append("Body", (Object)this.m_aBody).getToString();
    }
}

