/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jscode;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.js.JSMarshaller;
import com.helger.html.jscode.AbstractJSClass;
import com.helger.html.jscode.AbstractJSExpression;
import com.helger.html.jscode.IJSDeclaration;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSGeneratable;
import com.helger.html.jscode.IJSInvocation;
import com.helger.html.jscode.JSAnonymousFunction;
import com.helger.html.jscode.JSFormatter;
import com.helger.html.jscode.JSFunction;
import com.helger.html.jscode.JSMethod;
import com.helger.html.jscode.JSPrinter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public abstract class AbstractJSInvocation<IMPLTYPE extends AbstractJSInvocation<IMPLTYPE>>
extends AbstractJSExpression
implements IJSInvocation<IMPLTYPE> {
    private final IJSGeneratable m_aObject;
    private final IJSGeneratable m_aCtorType;
    private final String m_sName;
    private final Object m_aCallee;
    private final ICommonsList<IJSExpression> m_aArgs = new CommonsArrayList();

    protected AbstractJSInvocation(@Nonnull JSFunction jSFunction) {
        this.m_aObject = null;
        this.m_sName = null;
        this.m_aCallee = ValueEnforcer.notNull((Object)jSFunction, (String)"Function");
        this.m_aCtorType = null;
    }

    public AbstractJSInvocation(@Nonnull String string) {
        this.m_aObject = null;
        this.m_sName = (String)ValueEnforcer.notNull((Object)string, (String)"FunctionName");
        this.m_aCallee = null;
        this.m_aCtorType = null;
    }

    protected AbstractJSInvocation(@Nonnull JSAnonymousFunction jSAnonymousFunction) {
        this.m_aObject = null;
        this.m_sName = null;
        this.m_aCallee = ValueEnforcer.notNull((Object)jSAnonymousFunction, (String)"AnonymousFunction");
        this.m_aCtorType = null;
    }

    protected AbstractJSInvocation(@Nullable IJSExpression iJSExpression, @Nonnull @Nonempty String string) {
        this((IJSGeneratable)iJSExpression, string);
    }

    protected AbstractJSInvocation(@Nullable IJSExpression iJSExpression, @Nonnull JSMethod jSMethod) {
        this((IJSGeneratable)iJSExpression, jSMethod);
    }

    protected AbstractJSInvocation(@Nullable AbstractJSClass abstractJSClass, @Nonnull @Nonempty String string) {
        this((IJSGeneratable)abstractJSClass, string);
    }

    protected AbstractJSInvocation(@Nullable AbstractJSClass abstractJSClass, @Nonnull JSMethod jSMethod) {
        this((IJSGeneratable)abstractJSClass, jSMethod);
    }

    private AbstractJSInvocation(@Nullable IJSGeneratable iJSGeneratable, @Nonnull @Nonempty String string) {
        if (!JSMarshaller.isJSIdentifier((String)string)) {
            throw new IllegalArgumentException("The name '" + string + "' is not a legal JS identifier!");
        }
        this.m_aObject = iJSGeneratable;
        this.m_sName = string;
        this.m_aCallee = null;
        this.m_aCtorType = null;
    }

    private AbstractJSInvocation(@Nullable IJSGeneratable iJSGeneratable, @Nonnull JSMethod jSMethod) {
        this.m_aObject = iJSGeneratable;
        this.m_sName = null;
        this.m_aCallee = ValueEnforcer.notNull((Object)jSMethod, (String)"Method");
        this.m_aCtorType = null;
    }

    protected AbstractJSInvocation(@Nonnull IJSGeneratable iJSGeneratable) {
        this.m_aObject = null;
        this.m_sName = null;
        this.m_aCallee = null;
        this.m_aCtorType = (IJSGeneratable)ValueEnforcer.notNull((Object)iJSGeneratable, (String)"Type");
    }

    @Nonnull
    private IMPLTYPE _thisAsT() {
        return (IMPLTYPE)this;
    }

    @Override
    @Nonnull
    public IMPLTYPE arg(@Nonnull IJSExpression iJSExpression) {
        ValueEnforcer.notNull((Object)iJSExpression, (String)"Argument");
        this.m_aArgs.add((Object)iJSExpression);
        return this._thisAsT();
    }

    @Override
    @Nonnull
    public IMPLTYPE arg(@Nonnegative int n, @Nonnull IJSExpression iJSExpression) {
        ValueEnforcer.notNull((Object)iJSExpression, (String)"Argument");
        this.m_aArgs.add(n, (Object)iJSExpression);
        return this._thisAsT();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJSExpression> args() {
        return (ICommonsList)this.m_aArgs.getClone();
    }

    @Override
    @Nonnegative
    public int getArgCount() {
        return this.m_aArgs.size();
    }

    @Override
    public boolean hasArgs() {
        return this.m_aArgs.isNotEmpty();
    }

    @Override
    @Nullable
    public IJSExpression getArgAtIndex(int n) {
        return (IJSExpression)this.m_aArgs.getAtIndex(n);
    }

    @Override
    @Nonnull
    public IMPLTYPE removeAllArgs() {
        this.m_aArgs.clear();
        return this._thisAsT();
    }

    @Override
    public void generate(@Nonnull JSFormatter jSFormatter) {
        if (this.m_aCallee instanceof JSAnonymousFunction) {
            jSFormatter.generatable(((JSAnonymousFunction)this.m_aCallee).inParantheses()).plain('(');
        } else if (this.m_aCtorType != null) {
            jSFormatter.plain("new ").generatable(this.m_aCtorType).plain('(');
        } else {
            String string = this.m_sName;
            if (string == null && this.m_aCallee instanceof IJSDeclaration) {
                string = ((IJSDeclaration)this.m_aCallee).name();
            }
            if (this.m_aObject != null) {
                if (string == null) {
                    throw new IllegalStateException("Name is required if an object is present");
                }
                jSFormatter.generatable(this.m_aObject).plain('.').plain(string).plain('(');
            } else if (string != null) {
                jSFormatter.plain(string).plain('(');
            }
        }
        jSFormatter.generatable((Iterable<? extends IJSGeneratable>)this.m_aArgs).plain(')');
    }

    @Override
    public void state(@Nonnull JSFormatter jSFormatter) {
        jSFormatter.generatable(this).plain(';').nl();
    }

    @Override
    @Nonnull
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return JSPrinter.getAsString(iJSWriterSettings, this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractJSInvocation abstractJSInvocation = (AbstractJSInvocation)object;
        return EqualsHelper.equals((Object)this.m_aObject, (Object)abstractJSInvocation.m_aObject) && EqualsHelper.equals((Object)this.m_aCtorType, (Object)abstractJSInvocation.m_aCtorType) && EqualsHelper.equals((Object)this.m_aCallee, (Object)abstractJSInvocation.m_aCallee) && EqualsHelper.equals((Object)this.m_sName, (Object)abstractJSInvocation.m_sName) && this.m_aArgs.equals(abstractJSInvocation.m_aArgs);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append((Object)this.m_aObject).append((Object)this.m_aCtorType).append(this.m_aCallee).append((Object)this.m_sName).append(this.m_aArgs).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("object", (Object)this.m_aObject).appendIfNotNull("ctorType", (Object)this.m_aCtorType).appendIfNotNull("callee", this.m_aCallee).appendIfNotNull("name", (Object)this.m_sName).append("args", this.m_aArgs).getToString();
    }
}

