/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.jquery;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.CollectionFind;
import com.helger.collection.CollectionHelper;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCHasID;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.jquery.IJQuerySelector;
import com.helger.html.jquery.JQuery;
import com.helger.html.jquery.JQueryInvocation;
import com.helger.html.js.IJSWriterSettings;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.JSExpr;
import com.helger.html.jscode.JSStringLiteral;
import com.helger.xml.microdom.IMicroQName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

@Immutable
@CodingStyleguideUnaware
public final class JQuerySelector
implements IJQuerySelector {
    public static final IJQuerySelector all = new JQuerySelector("*");
    public static final IJQuerySelector animated = new JQuerySelector(":animated");
    public static final IJQuerySelector button = new JQuerySelector(":button");
    public static final IJQuerySelector checkbox = new JQuerySelector(":checkbox");
    public static final IJQuerySelector checked = new JQuerySelector(":checked");
    public static final IJQuerySelector disabled = new JQuerySelector(":disabled");
    public static final IJQuerySelector empty = new JQuerySelector(":empty");
    public static final IJQuerySelector enabled = new JQuerySelector(":enabled");
    public static final IJQuerySelector even = new JQuerySelector(":even");
    public static final IJQuerySelector file = new JQuerySelector(":file");
    public static final IJQuerySelector first = new JQuerySelector(":first");
    public static final IJQuerySelector first_child = new JQuerySelector(":first-child");
    public static final IJQuerySelector first_of_type = new JQuerySelector(":first-of-type");
    public static final IJQuerySelector focus = new JQuerySelector(":focus");
    public static final IJQuerySelector header = new JQuerySelector(":header");
    public static final IJQuerySelector hidden = new JQuerySelector(":hidden");
    public static final IJQuerySelector image = new JQuerySelector(":image");
    public static final IJQuerySelector input = new JQuerySelector(":input");
    public static final IJQuerySelector last = new JQuerySelector(":last");
    public static final IJQuerySelector last_child = new JQuerySelector(":last-child");
    public static final IJQuerySelector last_of_type = new JQuerySelector(":last-of-type");
    public static final IJQuerySelector odd = new JQuerySelector(":odd");
    public static final IJQuerySelector only_child = new JQuerySelector(":only-child");
    public static final IJQuerySelector only_of_type = new JQuerySelector(":only-of-type");
    public static final IJQuerySelector parent = new JQuerySelector(":parent");
    public static final IJQuerySelector password = new JQuerySelector(":password");
    public static final IJQuerySelector radio = new JQuerySelector(":radio");
    public static final IJQuerySelector reset = new JQuerySelector(":reset");
    public static final IJQuerySelector root = new JQuerySelector(":root");
    public static final IJQuerySelector selected = new JQuerySelector(":selected");
    public static final IJQuerySelector submit = new JQuerySelector(":submit");
    public static final IJQuerySelector target = new JQuerySelector(":target");
    public static final IJQuerySelector text = new JQuerySelector(":text");
    public static final IJQuerySelector visible = new JQuerySelector(":visible");
    private static final char[] ILLEGAL_JQUERY_ID_CHARS = new char[]{':', '.'};
    private final IJSExpression m_aExpr;

    private JQuerySelector(@Nonnull @Nonempty String string, @Nonnull IJSExpression iJSExpression) {
        this(string + "(" + iJSExpression.getJSCode(HCSettings.getConversionSettings().getJSWriterSettings()) + ")");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SelectorName");
    }

    private JQuerySelector(@Nonnull @Nonempty String string) {
        this((IJSExpression)JSExpr.lit((String)string));
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SelectorName");
    }

    public JQuerySelector(@Nonnull IJSExpression iJSExpression) {
        this.m_aExpr = (IJSExpression)ValueEnforcer.notNull((Object)iJSExpression, (String)"Expr");
    }

    @Override
    @Nonnull
    public IJSExpression getExpression() {
        return this.m_aExpr;
    }

    @Nonnull
    public String getJSCode(@Nullable IJSWriterSettings iJSWriterSettings) {
        return this.m_aExpr.getJSCode(iJSWriterSettings);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector chain(@Nonnull IJQuerySelector iJQuerySelector) {
        return JQuerySelector.chain(this, iJQuerySelector);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector multiple(@Nonnull IJQuerySelector iJQuerySelector) {
        return JQuerySelector.multiple(this, iJQuerySelector);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector child(@Nonnull IJQuerySelector iJQuerySelector) {
        return JQuerySelector.child(this, iJQuerySelector);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector descendant(@Nonnull IJQuerySelector iJQuerySelector) {
        return JQuerySelector.descendant(this, iJQuerySelector);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector nextAdjacent(@Nonnull IJQuerySelector iJQuerySelector) {
        return JQuerySelector.nextAdjacent(this, iJQuerySelector);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector nextSiblings(@Nonnull IJQuerySelector iJQuerySelector) {
        return JQuerySelector.nextSiblings(this, iJQuerySelector);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector animated() {
        return JQuerySelector.chain(this, animated);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector button() {
        return JQuerySelector.chain(this, button);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector checkbox() {
        return JQuerySelector.chain(this, checkbox);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector checked() {
        return JQuerySelector.chain(this, checked);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector disabled() {
        return JQuerySelector.chain(this, disabled);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector empty() {
        return JQuerySelector.chain(this, empty);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector enabled() {
        return JQuerySelector.chain(this, enabled);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector even() {
        return JQuerySelector.chain(this, even);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector file() {
        return JQuerySelector.chain(this, file);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector first() {
        return JQuerySelector.chain(this, first);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector first_child() {
        return JQuerySelector.chain(this, first_child);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector first_of_type() {
        return JQuerySelector.chain(this, first_of_type);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector focus() {
        return JQuerySelector.chain(this, focus);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector header() {
        return JQuerySelector.chain(this, header);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector hidden() {
        return JQuerySelector.chain(this, hidden);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector image() {
        return JQuerySelector.chain(this, image);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector input() {
        return JQuerySelector.chain(this, input);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector last() {
        return JQuerySelector.chain(this, last);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector last_child() {
        return JQuerySelector.chain(this, last_child);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector last_of_type() {
        return JQuerySelector.chain(this, last_of_type);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector odd() {
        return JQuerySelector.chain(this, odd);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector only_child() {
        return JQuerySelector.chain(this, only_child);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector only_of_type() {
        return JQuerySelector.chain(this, only_of_type);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector parent() {
        return JQuerySelector.chain(this, parent);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector password() {
        return JQuerySelector.chain(this, password);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector radio() {
        return JQuerySelector.chain(this, radio);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector reset() {
        return JQuerySelector.chain(this, reset);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector root() {
        return JQuerySelector.chain(this, root);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector selected() {
        return JQuerySelector.chain(this, selected);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector submit() {
        return JQuerySelector.chain(this, submit);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector target() {
        return JQuerySelector.chain(this, target);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector text() {
        return JQuerySelector.chain(this, text);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public IJQuerySelector visible() {
        return JQuerySelector.chain(this, visible);
    }

    @Override
    @Nonnull
    public JQueryInvocation invoke() {
        return JQuery.jQuery(this.getExpression());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("expr", (Object)this.m_aExpr).getToString();
    }

    @Nonnull
    public static IJQuerySelector attributeContains(@Nonnull IMicroQName iMicroQName, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iMicroQName, (String)"AttrName");
        return JQuerySelector.attributeContains(iMicroQName.getName(), string);
    }

    @Nonnull
    public static IJQuerySelector attributeContains(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        return new JQuerySelector("[" + string + "*=" + JSStringLiteral.getAsString((String)string2) + "]");
    }

    @Nonnull
    public static IJQuerySelector attributeContainsPrefix(@Nonnull IMicroQName iMicroQName, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iMicroQName, (String)"AttrName");
        return JQuerySelector.attributeContainsPrefix(iMicroQName.getName(), string);
    }

    @Nonnull
    public static IJQuerySelector attributeContainsPrefix(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        return new JQuerySelector("[" + string + "|=" + JSStringLiteral.getAsString((String)string2) + "]");
    }

    @Nonnull
    public static IJQuerySelector attributeContainsWord(@Nonnull IMicroQName iMicroQName, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iMicroQName, (String)"AttrName");
        return JQuerySelector.attributeContainsWord(iMicroQName.getName(), string);
    }

    @Nonnull
    public static IJQuerySelector attributeContainsWord(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        return new JQuerySelector("[" + string + "~=" + JSStringLiteral.getAsString((String)string2) + "]");
    }

    @Nonnull
    public static IJQuerySelector attributeEndsWith(@Nonnull IMicroQName iMicroQName, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iMicroQName, (String)"AttrName");
        return JQuerySelector.attributeEndsWith(iMicroQName.getName(), string);
    }

    @Nonnull
    public static IJQuerySelector attributeEndsWith(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        return new JQuerySelector("[" + string + "$=" + JSStringLiteral.getAsString((String)string2) + "]");
    }

    @Nonnull
    public static IJQuerySelector attributeEquals(@Nonnull IMicroQName iMicroQName, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iMicroQName, (String)"AttrName");
        return JQuerySelector.attributeEquals(iMicroQName.getName(), string);
    }

    @Nonnull
    public static IJQuerySelector attributeEquals(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        return new JQuerySelector("[" + string + "=" + JSStringLiteral.getAsString((String)string2) + "]");
    }

    @Nonnull
    public static IJQuerySelector attributeHas(@Nonnull IMicroQName iMicroQName) {
        ValueEnforcer.notNull((Object)iMicroQName, (String)"AttrName");
        return JQuerySelector.attributeHas(iMicroQName.getName());
    }

    @Nonnull
    public static IJQuerySelector attributeHas(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AttrName");
        return new JQuerySelector("[" + string + "]");
    }

    @Nonnull
    public static IJQuerySelector attributeNotEqual(@Nonnull IMicroQName iMicroQName, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iMicroQName, (String)"AttrName");
        return JQuerySelector.attributeNotEqual(iMicroQName.getName(), string);
    }

    @Nonnull
    public static IJQuerySelector attributeNotEqual(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        return new JQuerySelector("[" + string + "!=" + JSStringLiteral.getAsString((String)string2) + "]");
    }

    @Nonnull
    public static IJQuerySelector attributeStartsWith(@Nonnull IMicroQName iMicroQName, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iMicroQName, (String)"AttrName");
        return JQuerySelector.attributeStartsWith(iMicroQName.getName(), string);
    }

    @Nonnull
    public static IJQuerySelector attributeStartsWith(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        return new JQuerySelector("[" + string + "^=" + JSStringLiteral.getAsString((String)string2) + "]");
    }

    @Nonnull
    public static IJQuerySelector child(@Nonnull IJQuerySelector iJQuerySelector, @Nonnull IJQuerySelector iJQuerySelector2) {
        ValueEnforcer.notNull((Object)iJQuerySelector, (String)"ParentSelector");
        ValueEnforcer.notNull((Object)iJQuerySelector2, (String)"ChildSelector");
        return new JQuerySelector(iJQuerySelector.getExpression().plus((IJSExpression)JSExpr.lit((String)" > ")).plus(iJQuerySelector2.getExpression()));
    }

    @Nonnull
    public static IJQuerySelector clazz(@Nonnull ICSSClassProvider iCSSClassProvider) {
        ValueEnforcer.notNull((Object)iCSSClassProvider, (String)"CSSClass");
        return new JQuerySelector("." + iCSSClassProvider.getCSSClass());
    }

    @Nonnull
    public static IJQuerySelector contains(@Nonnull String string) {
        return JQuerySelector.contains((IJSExpression)JSExpr.lit((String)string));
    }

    @Nonnull
    public static IJQuerySelector contains(@Nonnull IJSExpression iJSExpression) {
        return new JQuerySelector(":contains", iJSExpression);
    }

    @Nonnull
    public static IJQuerySelector descendant(@Nonnull IJQuerySelector iJQuerySelector, @Nonnull IJQuerySelector iJQuerySelector2) {
        ValueEnforcer.notNull((Object)iJQuerySelector, (String)"AncestorSelector");
        ValueEnforcer.notNull((Object)iJQuerySelector2, (String)"DescendantSelector");
        return new JQuerySelector(iJQuerySelector.getExpression().plus(" ").plus(iJQuerySelector2.getExpression()));
    }

    @Nonnull
    public static IJQuerySelector element(@Nonnull EHTMLElement eHTMLElement) {
        ValueEnforcer.notNull((Object)eHTMLElement, (String)"HTMLElement");
        return JQuerySelector.element(eHTMLElement.getElementName());
    }

    @Nonnull
    public static IJQuerySelector element(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ElementName");
        return new JQuerySelector(string);
    }

    @Nonnull
    public static IJQuerySelector eq(int n) {
        return JQuerySelector.eq((IJSExpression)JSExpr.lit((int)n));
    }

    @Nonnull
    public static IJQuerySelector eq(long l) {
        return JQuerySelector.eq((IJSExpression)JSExpr.lit((long)l));
    }

    @Nonnull
    public static IJQuerySelector eq(@Nonnull BigInteger bigInteger) {
        return JQuerySelector.eq((IJSExpression)JSExpr.lit((BigInteger)bigInteger));
    }

    @Nonnull
    public static IJQuerySelector eq(double d) {
        return JQuerySelector.eq((IJSExpression)JSExpr.lit((double)d));
    }

    @Nonnull
    public static IJQuerySelector eq(@Nonnull BigDecimal bigDecimal) {
        return JQuerySelector.eq((IJSExpression)JSExpr.lit((BigDecimal)bigDecimal));
    }

    @Nonnull
    public static IJQuerySelector eq(@Nonnull IJSExpression iJSExpression) {
        return new JQuerySelector(":eq", iJSExpression);
    }

    @Nonnull
    public static IJQuerySelector gt(int n) {
        return JQuerySelector.gt((IJSExpression)JSExpr.lit((int)n));
    }

    @Nonnull
    public static IJQuerySelector gt(long l) {
        return JQuerySelector.gt((IJSExpression)JSExpr.lit((long)l));
    }

    @Nonnull
    public static IJQuerySelector gt(@Nonnull BigInteger bigInteger) {
        return JQuerySelector.gt((IJSExpression)JSExpr.lit((BigInteger)bigInteger));
    }

    @Nonnull
    public static IJQuerySelector gt(double d) {
        return JQuerySelector.gt((IJSExpression)JSExpr.lit((double)d));
    }

    @Nonnull
    public static IJQuerySelector gt(@Nonnull BigDecimal bigDecimal) {
        return JQuerySelector.gt((IJSExpression)JSExpr.lit((BigDecimal)bigDecimal));
    }

    @Nonnull
    public static IJQuerySelector gt(@Nonnull IJSExpression iJSExpression) {
        return new JQuerySelector(":gt", iJSExpression);
    }

    @Nonnull
    public static IJQuerySelector has(@Nonnull IJQuerySelector iJQuerySelector) {
        return new JQuerySelector(":has", iJQuerySelector.getExpression());
    }

    @Nonnull
    public static IJQuerySelector has(@Nonnull IJSExpression iJSExpression) {
        return new JQuerySelector(":has", iJSExpression);
    }

    @Nonnull
    @Nonempty
    public static String getValidJQueryID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        if (!StringHelper.containsAny((String)string, (char[])ILLEGAL_JQUERY_ID_CHARS)) {
            return string;
        }
        return RegExHelper.stringReplacePattern((String)"(:|\\.)", (String)string, (String)"\\\\$1");
    }

    @Nonnull
    public static IJQuerySelector id(@Nonnull IHasID<String> iHasID) {
        return JQuerySelector.id((String)iHasID.getID());
    }

    @Nonnull
    public static IJQuerySelector id(@Nonnull IHCHasID<?> iHCHasID) {
        return JQuerySelector.id(iHCHasID.ensureID().getID());
    }

    @Nonnull
    public static IJQuerySelector id(@Nonnull @Nonempty String string) {
        String string2 = JQuerySelector.getValidJQueryID(string);
        return new JQuerySelector("#" + string2);
    }

    @Nonnull
    public static IJQuerySelector id(@Nonnull IJSExpression iJSExpression) {
        return new JQuerySelector((IJSExpression)JSExpr.lit((char)'#').plus(iJSExpression));
    }

    @Nonnull
    public static IJQuerySelector lang(@Nonnull @Nonempty String string) {
        return JQuerySelector.lang((IJSExpression)JSExpr.lit((String)string));
    }

    @Nonnull
    public static IJQuerySelector lang(@Nonnull @Nonempty IJSExpression iJSExpression) {
        return new JQuerySelector(":lang", iJSExpression);
    }

    @Nonnull
    public static IJQuerySelector lt(int n) {
        return JQuerySelector.lt((IJSExpression)JSExpr.lit((int)n));
    }

    @Nonnull
    public static IJQuerySelector lt(long l) {
        return JQuerySelector.lt((IJSExpression)JSExpr.lit((long)l));
    }

    @Nonnull
    public static IJQuerySelector lt(@Nonnull BigInteger bigInteger) {
        return JQuerySelector.lt((IJSExpression)JSExpr.lit((BigInteger)bigInteger));
    }

    @Nonnull
    public static IJQuerySelector lt(double d) {
        return JQuerySelector.lt((IJSExpression)JSExpr.lit((double)d));
    }

    @Nonnull
    public static IJQuerySelector lt(@Nonnull BigDecimal bigDecimal) {
        return JQuerySelector.lt((IJSExpression)JSExpr.lit((BigDecimal)bigDecimal));
    }

    @Nonnull
    public static IJQuerySelector lt(@Nonnull IJSExpression iJSExpression) {
        return new JQuerySelector(":lt", iJSExpression);
    }

    @Nonnull
    public static IJQuerySelector multiple(IJQuerySelector ... iJQuerySelectorArray) {
        int n = ArrayHelper.getSize((Object[])iJQuerySelectorArray);
        if (n == 0) {
            throw new IllegalArgumentException("empty selectors");
        }
        if (ArrayHelper.containsAnyNullElement((Object[])iJQuerySelectorArray)) {
            throw new IllegalArgumentException("selectors array contains null element");
        }
        if (n == 1) {
            return iJQuerySelectorArray[0];
        }
        IJSExpression iJSExpression = iJQuerySelectorArray[0].getExpression();
        for (int i = 1; i < n; ++i) {
            iJSExpression = iJSExpression.plus(',').plus(iJQuerySelectorArray[i].getExpression());
        }
        return new JQuerySelector(iJSExpression);
    }

    @Nonnull
    public static IJQuerySelector multiple(@Nonnull @Nonempty List<IJQuerySelector> list) {
        int n = CollectionHelper.getSize(list);
        if (n == 0) {
            throw new IllegalArgumentException("empty selectors");
        }
        if (CollectionFind.containsAnyNullElement(list)) {
            throw new IllegalArgumentException("selectors collection contains null element");
        }
        if (n == 1) {
            return (IJQuerySelector)CollectionFind.getFirstElement(list);
        }
        IJSExpression iJSExpression = list.get(0).getExpression();
        for (int i = 1; i < n; ++i) {
            iJSExpression = iJSExpression.plus(',').plus(list.get(i).getExpression());
        }
        return new JQuerySelector(iJSExpression);
    }

    @Nonnull
    public static IJQuerySelector nameAttr(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"NameAttrValue");
        return JQuerySelector.attributeEquals(CHTMLAttributes.NAME, string);
    }

    @Nonnull
    public static IJQuerySelector nextAdjacent(@Nonnull IJQuerySelector iJQuerySelector, @Nonnull IJQuerySelector iJQuerySelector2) {
        ValueEnforcer.notNull((Object)iJQuerySelector, (String)"PrevSelector");
        ValueEnforcer.notNull((Object)iJQuerySelector2, (String)"NextSelector");
        return new JQuerySelector(iJQuerySelector.getExpression().plus((IJSExpression)JSExpr.lit((String)" + ")).plus(iJQuerySelector2.getExpression()));
    }

    @Nonnull
    public static IJQuerySelector nextSiblings(@Nonnull IJQuerySelector iJQuerySelector, @Nonnull IJQuerySelector iJQuerySelector2) {
        ValueEnforcer.notNull((Object)iJQuerySelector, (String)"PrevSelector");
        ValueEnforcer.notNull((Object)iJQuerySelector2, (String)"SiblingsSelector");
        return new JQuerySelector(iJQuerySelector.getExpression().plus((IJSExpression)JSExpr.lit((String)" ~ ")).plus(iJQuerySelector2.getExpression()));
    }

    @Nonnull
    public static IJQuerySelector not(@Nonnull IJQuerySelector iJQuerySelector) {
        return JQuerySelector.not(iJQuerySelector.getExpression());
    }

    @Nonnull
    public static IJQuerySelector not(@Nonnull IJSExpression iJSExpression) {
        return new JQuerySelector(":not", iJSExpression);
    }

    @Nonnull
    public static IJQuerySelector nthChild(int n) {
        return JQuerySelector.nthChild((IJSExpression)JSExpr.lit((int)n));
    }

    @Nonnull
    public static IJQuerySelector nthChild(long l) {
        return JQuerySelector.nthChild((IJSExpression)JSExpr.lit((long)l));
    }

    @Nonnull
    public static IJQuerySelector nthChild(@Nonnull BigInteger bigInteger) {
        return JQuerySelector.nthChild((IJSExpression)JSExpr.lit((BigInteger)bigInteger));
    }

    @Nonnull
    public static IJQuerySelector nthChild(double d) {
        return JQuerySelector.nthChild((IJSExpression)JSExpr.lit((double)d));
    }

    @Nonnull
    public static IJQuerySelector nthChild(@Nonnull BigDecimal bigDecimal) {
        return JQuerySelector.nthChild((IJSExpression)JSExpr.lit((BigDecimal)bigDecimal));
    }

    @Nonnull
    public static IJQuerySelector nthChild(@Nonnull IJSExpression iJSExpression) {
        return new JQuerySelector(":nth-child", iJSExpression);
    }

    @Nonnull
    public static IJQuerySelector nthLastChild(int n) {
        return JQuerySelector.nthLastChild((IJSExpression)JSExpr.lit((int)n));
    }

    @Nonnull
    public static IJQuerySelector nthLastChild(long l) {
        return JQuerySelector.nthLastChild((IJSExpression)JSExpr.lit((long)l));
    }

    @Nonnull
    public static IJQuerySelector nthLastChild(@Nonnull BigInteger bigInteger) {
        return JQuerySelector.nthLastChild((IJSExpression)JSExpr.lit((BigInteger)bigInteger));
    }

    @Nonnull
    public static IJQuerySelector nthLastChild(double d) {
        return JQuerySelector.nthLastChild((IJSExpression)JSExpr.lit((double)d));
    }

    @Nonnull
    public static IJQuerySelector nthLastChild(@Nonnull BigDecimal bigDecimal) {
        return JQuerySelector.nthLastChild((IJSExpression)JSExpr.lit((BigDecimal)bigDecimal));
    }

    @Nonnull
    public static IJQuerySelector nthLastChild(@Nonnull IJSExpression iJSExpression) {
        return new JQuerySelector(":nth-last-child", iJSExpression);
    }

    @Nonnull
    public static IJQuerySelector nthLastOfType(int n) {
        return JQuerySelector.nthLastOfType((IJSExpression)JSExpr.lit((int)n));
    }

    @Nonnull
    public static IJQuerySelector nthLastOfType(long l) {
        return JQuerySelector.nthLastOfType((IJSExpression)JSExpr.lit((long)l));
    }

    @Nonnull
    public static IJQuerySelector nthLastOfType(@Nonnull BigInteger bigInteger) {
        return JQuerySelector.nthLastOfType((IJSExpression)JSExpr.lit((BigInteger)bigInteger));
    }

    @Nonnull
    public static IJQuerySelector nthLastOfType(double d) {
        return JQuerySelector.nthLastOfType((IJSExpression)JSExpr.lit((double)d));
    }

    @Nonnull
    public static IJQuerySelector nthLastOfType(@Nonnull BigDecimal bigDecimal) {
        return JQuerySelector.nthLastOfType((IJSExpression)JSExpr.lit((BigDecimal)bigDecimal));
    }

    @Nonnull
    public static IJQuerySelector nthLastOfType(@Nonnull IJSExpression iJSExpression) {
        return new JQuerySelector(":nth-last-of-type", iJSExpression);
    }

    @Nonnull
    public static IJQuerySelector nthOfType(int n) {
        return JQuerySelector.nthOfType((IJSExpression)JSExpr.lit((int)n));
    }

    @Nonnull
    public static IJQuerySelector nthOfType(long l) {
        return JQuerySelector.nthOfType((IJSExpression)JSExpr.lit((long)l));
    }

    @Nonnull
    public static IJQuerySelector nthOfType(@Nonnull BigInteger bigInteger) {
        return JQuerySelector.nthOfType((IJSExpression)JSExpr.lit((BigInteger)bigInteger));
    }

    @Nonnull
    public static IJQuerySelector nthOfType(double d) {
        return JQuerySelector.nthOfType((IJSExpression)JSExpr.lit((double)d));
    }

    @Nonnull
    public static IJQuerySelector nthOfType(@Nonnull BigDecimal bigDecimal) {
        return JQuerySelector.nthOfType((IJSExpression)JSExpr.lit((BigDecimal)bigDecimal));
    }

    @Nonnull
    public static IJQuerySelector nthOfType(@Nonnull IJSExpression iJSExpression) {
        return new JQuerySelector(":nth-of-type", iJSExpression);
    }

    @Nonnull
    public static IJQuerySelector chain(@Nonnull IJQuerySelector iJQuerySelector, @Nonnull IJQuerySelector iJQuerySelector2) {
        ValueEnforcer.notNull((Object)iJQuerySelector, (String)"FirstSelector");
        ValueEnforcer.notNull((Object)iJQuerySelector2, (String)"SecondSelector");
        return new JQuerySelector(iJQuerySelector.getExpression().plus(iJQuerySelector2.getExpression()));
    }
}

