/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.resource.js;

import com.helger.annotation.Nonempty;
import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.hc.html.script.EHCScriptLoadingMode;
import com.helger.html.js.JSFilenameHelper;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.html.resource.js.IJSProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public final class ConstantJSPathProvider
implements IJSPathProvider {
    private final String m_sPath;
    private final String m_sMinifiedPath;
    private final String m_sConditionalComment;
    private final boolean m_bIsBundlable;
    private final EHCScriptLoadingMode m_eScriptLoadingMode;

    protected ConstantJSPathProvider(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, boolean bl, @Nonnull EHCScriptLoadingMode eHCScriptLoadingMode) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        ValueEnforcer.isTrue((boolean)JSFilenameHelper.isJSFilename(string), () -> "'" + string + "' is not a valid JS filename");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"MinifiedPath");
        ValueEnforcer.isTrue((boolean)JSFilenameHelper.isJSFilename(string2), () -> "'" + string2 + "' is not a valid minified JS filename");
        ValueEnforcer.notNull((Object)((Object)eHCScriptLoadingMode), (String)"ScriptLoadingMode");
        this.m_sPath = string;
        this.m_sMinifiedPath = string2;
        this.m_sConditionalComment = string3;
        this.m_bIsBundlable = bl;
        this.m_eScriptLoadingMode = eHCScriptLoadingMode;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getJSItemPath(boolean bl) {
        return bl ? this.m_sPath : this.m_sMinifiedPath;
    }

    @Nonnull
    @Nonempty
    public String getJSItemPathRegular() {
        return this.m_sPath;
    }

    @Nonnull
    @Nonempty
    public String getJSItemPathMinified() {
        return this.m_sMinifiedPath;
    }

    @Override
    @Nullable
    public String getConditionalComment() {
        return this.m_sConditionalComment;
    }

    @Override
    public boolean isBundlable() {
        return this.m_bIsBundlable;
    }

    @Override
    @Nonnull
    public EHCScriptLoadingMode getScriptLoadingMode() {
        return this.m_eScriptLoadingMode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ConstantJSPathProvider constantJSPathProvider = (ConstantJSPathProvider)object;
        return this.m_sPath.equals(constantJSPathProvider.m_sPath) && this.m_sMinifiedPath.equals(constantJSPathProvider.m_sMinifiedPath) && EqualsHelper.equals((Object)this.m_sConditionalComment, (Object)constantJSPathProvider.m_sConditionalComment) && this.m_bIsBundlable == constantJSPathProvider.m_bIsBundlable && this.m_eScriptLoadingMode == constantJSPathProvider.m_eScriptLoadingMode;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPath).append((Object)this.m_sMinifiedPath).append((Object)this.m_sConditionalComment).append(this.m_bIsBundlable).append((Object)this.m_eScriptLoadingMode).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("path", (Object)this.m_sPath).append("minifiedPath", (Object)this.m_sMinifiedPath).appendIfNotNull("conditionalComment", (Object)this.m_sConditionalComment).append("isBundlable", this.m_bIsBundlable).append("ScriptLoadingMode", (Enum)this.m_eScriptLoadingMode).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements IBuilder<ConstantJSPathProvider> {
        private String m_sPath;
        private String m_sMinifiedPath;
        private String m_sConditionalComment = IJSProvider.DEFAULT_CONDITIONAL_COMMENT;
        private boolean m_bIsBundlable = true;
        private EHCScriptLoadingMode m_eScriptLoadingMode = EHCScriptLoadingMode.DEFAULT;

        @Nonnull
        public Builder path(@Nullable String string) {
            this.m_sPath = string;
            return this;
        }

        @Nonnull
        public Builder minifiedPath(@Nullable String string) {
            this.m_sMinifiedPath = string;
            return this;
        }

        @Nonnull
        public Builder minifiedPathFromPath() {
            return this.minifiedPath(JSFilenameHelper.getMinifiedJSFilename(this.m_sPath));
        }

        @Nonnull
        public Builder conditionalComment(@Nullable String string) {
            this.m_sConditionalComment = string;
            return this;
        }

        @Nonnull
        public Builder bundlable(boolean bl) {
            this.m_bIsBundlable = bl;
            return this;
        }

        @Nonnull
        public Builder scriptLoadingMode(@Nullable EHCScriptLoadingMode eHCScriptLoadingMode) {
            this.m_eScriptLoadingMode = eHCScriptLoadingMode;
            return this;
        }

        @Nonnull
        public Builder scriptLoadingAsync() {
            return this.scriptLoadingMode(EHCScriptLoadingMode.ASYNC);
        }

        @Nonnull
        public ConstantJSPathProvider build() {
            return new ConstantJSPathProvider(this.m_sPath, this.m_sMinifiedPath, this.m_sConditionalComment, this.m_bIsBundlable, this.m_eScriptLoadingMode);
        }
    }
}

