/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.parser;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.cache.regex.RegExHelper;
import com.helger.html.EHTMLElement;
import com.helger.html.EHTMLVersion;
import com.helger.html.entity.HTMLEntityResolver;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroContainer;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.serialize.read.ISAXReaderSettings;
import com.helger.xml.serialize.read.SAXReaderSettings;
import com.helger.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.xml.serialize.write.EXMLSerializeVersion;
import com.helger.xml.serialize.write.XMLEmitter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.xml.sax.EntityResolver;

@NotThreadSafe
public class XHTMLParser {
    private final EHTMLVersion m_eHTMLVersion;
    private SAXReaderSettings m_aSAXReaderSettings = XHTMLParser.createDefaultSAXReaderSettings();

    @Nonnull
    @ReturnsMutableCopy
    public static SAXReaderSettings createDefaultSAXReaderSettings() {
        return new SAXReaderSettings().setFeatureValue(EXMLParserFeature.SECURE_PROCESSING, true).setFeatureValue(EXMLParserFeature.DISALLOW_DOCTYPE_DECL, false).setFeatureValue(EXMLParserFeature.EXTERNAL_GENERAL_ENTITIES, false).setFeatureValue(EXMLParserFeature.EXTERNAL_PARAMETER_ENTITIES, true).setFeatureValue(EXMLParserFeature.LOAD_EXTERNAL_DTD, true).setEntityResolver((EntityResolver)HTMLEntityResolver.getInstance());
    }

    public XHTMLParser(@Nonnull EHTMLVersion eHTMLVersion) {
        this.m_eHTMLVersion = (EHTMLVersion)((Object)ValueEnforcer.notNull((Object)((Object)eHTMLVersion), (String)"HTMLVersion"));
    }

    @Nonnull
    public EHTMLVersion getHTMLVersion() {
        return this.m_eHTMLVersion;
    }

    @Nonnull
    @ReturnsMutableCopy
    public SAXReaderSettings getSAXReaderSettings() {
        return this.m_aSAXReaderSettings.getClone();
    }

    @Nonnull
    public XHTMLParser setSAXReaderSettings(@Nullable ISAXReaderSettings iSAXReaderSettings) {
        this.m_aSAXReaderSettings = SAXReaderSettings.createCloneOnDemand((ISAXReaderSettings)iSAXReaderSettings);
        return this;
    }

    public static boolean looksLikeXHTML(@Nullable String string) {
        return StringHelper.isNotEmpty((String)string) && RegExHelper.stringMatchesPattern((String)"(?s).*<[a-zA-Z].+", (String)string);
    }

    public boolean isValidXHTMLFragment(@Nullable String string) {
        return StringHelper.isEmpty((String)string) || this.parseXHTMLFragment(string) != null;
    }

    @Nullable
    public IMicroDocument parseXHTMLFragment(@Nullable String string) {
        String string2 = this.m_eHTMLVersion.getNamespaceURI();
        String string3 = XMLEmitter.getDocTypeHTMLRepresentation((EXMLSerializeVersion)EXMLSerializeVersion.XML_10, (EXMLIncorrectCharacterHandling)EXMLIncorrectCharacterHandling.DEFAULT, (IMicroDocumentType)this.m_eHTMLVersion.getDocType()) + "<html" + (String)(string2 != null ? " xmlns=\"" + string2 + "\"" : "") + "><head><title></title></head><body>" + StringHelper.getNotNull((String)string) + "</body></html>";
        return this.parseXHTMLDocument(string3);
    }

    @Nullable
    public IMicroDocument parseXHTMLDocument(@Nullable String string) {
        return MicroReader.readMicroXML((String)string, (ISAXReaderSettings)this.m_aSAXReaderSettings);
    }

    @Nullable
    public IMicroContainer unescapeXHTMLFragment(@Nullable String string) {
        IMicroElement iMicroElement;
        IMicroDocument iMicroDocument = this.parseXHTMLFragment(string);
        if (iMicroDocument != null && iMicroDocument.getDocumentElement() != null && (iMicroElement = iMicroDocument.getDocumentElement().getFirstChildElement(EHTMLElement.BODY.getElementName())) != null) {
            MicroContainer microContainer = new MicroContainer();
            if (iMicroElement.hasChildren()) {
                for (IMicroNode iMicroNode : iMicroElement.getAllChildren()) {
                    microContainer.addChild(iMicroNode.detachFromParent());
                }
            }
            return microContainer;
        }
        return null;
    }
}

