/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.meta;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.html.CHTMLAttributes;
import com.helger.html.EHTMLElement;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.meta.EMetaElementType;
import com.helger.html.meta.IMetaElement;
import com.helger.html.meta.IMetaElementValue;
import com.helger.html.meta.IMutableMetaElement;
import com.helger.html.meta.MetaElementValue;
import com.helger.text.locale.LocaleHelper;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroContainer;
import com.helger.xml.microdom.MicroQName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MetaElement
implements IMutableMetaElement,
ICloneable<MetaElement> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaElement.class);
    private EMetaElementType m_eType;
    private String m_sName;
    private String m_sScheme;
    private final ICommonsOrderedMap<Locale, String> m_aContents = new CommonsLinkedHashMap();

    public MetaElement(@Nonnull IMetaElement iMetaElement) {
        this.setType(iMetaElement.getType());
        this.setName(iMetaElement.getName());
        this.setScheme(iMetaElement.getScheme());
        this.m_aContents.putAll(iMetaElement.getContentMap());
    }

    protected MetaElement(@Nonnull EMetaElementType eMetaElementType, @Nonnull String string, @Nullable String string2, @Nullable Locale locale, @Nullable String string3) {
        this.setType(eMetaElementType);
        this.setName(string);
        this.setScheme(string2);
        this.setContent(locale, string3);
    }

    @Override
    @Nonnull
    public EMetaElementType getType() {
        return this.m_eType;
    }

    @Override
    @Nonnull
    public final EChange setType(@Nonnull EMetaElementType eMetaElementType) {
        ValueEnforcer.notNull((Object)((Object)eMetaElementType), (String)"Type");
        if (eMetaElementType.equals((Object)this.m_eType)) {
            return EChange.UNCHANGED;
        }
        this.m_eType = eMetaElementType;
        return EChange.CHANGED;
    }

    @Nonnull
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public final EChange setName(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        if (string.equals(this.m_sName)) {
            return EChange.UNCHANGED;
        }
        this.m_sName = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getScheme() {
        return this.m_sScheme;
    }

    @Nonnull
    public EChange setScheme(@Nullable String string) {
        if (EqualsHelper.equals((Object)string, (Object)this.m_sScheme)) {
            return EChange.UNCHANGED;
        }
        this.m_sScheme = string;
        return EChange.CHANGED;
    }

    @Override
    public boolean isLanguageIndependent() {
        return this.m_aContents.containsKey((Object)LocaleHelper.LOCALE_INDEPENDENT);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<Locale> getAllLocales() {
        return this.m_aContents.copyOfKeySet();
    }

    @Override
    @Nullable
    public String getContentLanguageIndependent() {
        return (String)this.m_aContents.get((Object)LocaleHelper.LOCALE_INDEPENDENT);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<Locale, String> getContentMap() {
        return this.m_aContents.getClone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Iterable<Map.Entry<Locale, String>> getContent() {
        return this.m_aContents.entrySet();
    }

    @Nonnull
    public static Locale getRealContentLocale(@Nullable Locale locale) {
        return locale == null ? LocaleHelper.LOCALE_INDEPENDENT : locale;
    }

    @Override
    @Nonnull
    public EChange setContent(@Nullable Locale locale, @Nullable String string) {
        Locale locale2 = MetaElement.getRealContentLocale(locale);
        String string2 = (String)this.m_aContents.get((Object)locale2);
        if (EqualsHelper.equals((Object)string2, (Object)string)) {
            return EChange.UNCHANGED;
        }
        if (string == null) {
            this.m_aContents.remove((Object)locale2);
        } else {
            this.m_aContents.put((Object)locale2, (Object)string);
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange removeContent(@Nullable Locale locale) {
        Locale locale2 = MetaElement.getRealContentLocale(locale);
        if (!this.m_aContents.containsKey((Object)locale2)) {
            return EChange.UNCHANGED;
        }
        this.m_aContents.remove((Object)locale2);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMetaElementValue> getAsMetaElementValueList() {
        CommonsArrayList commonsArrayList = new CommonsArrayList(this.m_aContents.size());
        for (Map.Entry entry : this.m_aContents.entrySet()) {
            commonsArrayList.add((Object)new MetaElementValue(this.m_eType, this.m_sName, (Locale)entry.getKey(), (String)entry.getValue()));
        }
        return commonsArrayList;
    }

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getNamespaceURI(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        return iHCConversionSettingsToNode.getHTMLNamespaceURI();
    }

    @Override
    @Nullable
    public IMicroNode convertToNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        if (this.m_aContents.isEmpty()) {
            LOGGER.info("Meta element '" + this.m_sName + "' has no content!");
            return null;
        }
        String string = this.getNamespaceURI(iHCConversionSettingsToNode);
        boolean bl = iHCConversionSettingsToNode.getHTMLVersion().isAtLeastHTML5();
        MicroContainer microContainer = new MicroContainer();
        for (Map.Entry entry : this.m_aContents.entrySet()) {
            Locale locale;
            IMicroElement iMicroElement = microContainer.addElementNS(string, EHTMLElement.META.getElementName());
            String string2 = (String)entry.getValue();
            switch (this.m_eType) {
                case DOCUMENT_LEVEL: 
                case PRAGMA_DIRECTIVE: {
                    iMicroElement.setAttribute(this.m_eType.getAttrName(), this.m_sName);
                    iMicroElement.setAttribute(CHTMLAttributes.CONTENT, string2);
                    break;
                }
                case CHARSET: {
                    iMicroElement.setAttribute(this.m_eType.getAttrName(), string2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported meta element type!");
                }
            }
            if (this.m_eType.isMultilingual() && (locale = (Locale)entry.getKey()) != null && !LocaleHelper.isSpecialLocale((Locale)locale)) {
                String string3 = locale.toString();
                iMicroElement.setAttribute((IMicroQName)new MicroQName("http://www.w3.org/XML/1998/namespace", CHTMLAttributes.LANG.getName()), string3);
                if (bl) {
                    iMicroElement.setAttribute(CHTMLAttributes.LANG, string3);
                }
            }
            if (bl || !StringHelper.isNotEmpty((String)this.m_sScheme)) continue;
            iMicroElement.setAttribute(CHTMLAttributes.SCHEME, this.m_sScheme);
        }
        return microContainer;
    }

    @Nonnull
    @ReturnsMutableCopy
    public MetaElement getClone() {
        return new MetaElement(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MetaElement metaElement = (MetaElement)object;
        return this.m_eType.equals((Object)metaElement.m_eType) && this.m_sName.equals(metaElement.m_sName) && EqualsHelper.equals((Object)this.m_sScheme, (Object)metaElement.m_sScheme) && this.m_aContents.equals(metaElement.m_aContents);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_eType).append((Object)this.m_sName).append((Object)this.m_sScheme).append(this.m_aContents).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("type", (Enum)this.m_eType).append("name", (Object)this.m_sName).appendIfNotNull("scheme", (Object)this.m_sScheme).append("contents", this.m_aContents).getToString();
    }

    @Nonnull
    public static MetaElement createMeta(@Nonnull String string, @Nonnull String string2) {
        return new MetaElement(EMetaElementType.DOCUMENT_LEVEL, string, null, null, string2);
    }

    @Nonnull
    public static MetaElement createMetaHttpEquiv(@Nonnull String string, @Nonnull String string2) {
        return new MetaElement(EMetaElementType.PRAGMA_DIRECTIVE, string, null, null, string2);
    }

    @Nonnull
    public static MetaElement createMetaCharset(@Nonnull Charset charset) {
        return new MetaElement(EMetaElementType.CHARSET, "", null, null, charset.name());
    }
}

