/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.markdown;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.html.markdown.AbstractMarkdownPlugin;
import com.helger.html.markdown.IMarkdownBlockEmitter;
import com.helger.html.markdown.IMarkdownDecorator;
import com.helger.html.markdown.IMarkdownSpanEmitter;
import com.helger.html.markdown.MarkdownDefaultDecorator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class MarkdownConfiguration {
    public static final MarkdownConfiguration DEFAULT = MarkdownConfiguration.builder().build();
    public static final MarkdownConfiguration DEFAULT_EXTENSIONS = MarkdownConfiguration.builder().extendedProfile(true).build();
    public static final MarkdownConfiguration DEFAULT_SAFE = MarkdownConfiguration.builder().safeMode(true).build();
    public static final MarkdownConfiguration DEFAULT_SAFE_EXTENSIONS = MarkdownConfiguration.builder().safeMode(true).extendedProfile(true).build();
    private final boolean m_bSafeMode;
    private final Charset m_aEncoding;
    private final IMarkdownDecorator m_aDecorator;
    private final IMarkdownBlockEmitter m_aCodeBlockEmitter;
    private final boolean m_bForceExtendedProfile;
    private final boolean m_bConvertNewline2Br;
    private final IMarkdownSpanEmitter m_aSpecialLinkEmitter;
    private final ICommonsList<AbstractMarkdownPlugin> m_aPlugins;

    public MarkdownConfiguration(boolean bl, @Nonnull Charset charset, @Nonnull IMarkdownDecorator iMarkdownDecorator, @Nullable IMarkdownBlockEmitter iMarkdownBlockEmitter, boolean bl2, boolean bl3, @Nullable IMarkdownSpanEmitter iMarkdownSpanEmitter, @Nullable List<? extends AbstractMarkdownPlugin> list) {
        ValueEnforcer.notNull((Object)charset, (String)"Encoding");
        ValueEnforcer.notNull((Object)iMarkdownDecorator, (String)"Decorator");
        this.m_bSafeMode = bl;
        this.m_aEncoding = charset;
        this.m_aDecorator = iMarkdownDecorator;
        this.m_aCodeBlockEmitter = iMarkdownBlockEmitter;
        this.m_bForceExtendedProfile = bl2;
        this.m_bConvertNewline2Br = bl3;
        this.m_aSpecialLinkEmitter = iMarkdownSpanEmitter;
        this.m_aPlugins = new CommonsArrayList(list);
    }

    public boolean isSafeMode() {
        return this.m_bSafeMode;
    }

    @Nonnull
    public Charset getEncoding() {
        return this.m_aEncoding;
    }

    @Nonnull
    public IMarkdownDecorator getDecorator() {
        return this.m_aDecorator;
    }

    @Nullable
    public IMarkdownBlockEmitter getCodeBlockEmitter() {
        return this.m_aCodeBlockEmitter;
    }

    public boolean isExtendedProfile() {
        return this.m_bForceExtendedProfile;
    }

    public boolean isConvertNewline2Br() {
        return this.m_bConvertNewline2Br;
    }

    @Nullable
    public IMarkdownSpanEmitter getSpecialLinkEmitter() {
        return this.m_aSpecialLinkEmitter;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<AbstractMarkdownPlugin> getAllPlugins() {
        return (ICommonsList)this.m_aPlugins.getClone();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IBuilder<MarkdownConfiguration> {
        private boolean m_bSafeMode = false;
        private boolean m_bForceExtendedProfile = false;
        private boolean m_bConvertNewline2Br = false;
        private Charset m_aEncoding = StandardCharsets.UTF_8;
        private IMarkdownDecorator m_aDecorator = new MarkdownDefaultDecorator();
        private IMarkdownBlockEmitter m_aCodeBlockEmitter = null;
        private IMarkdownSpanEmitter m_aSpecialLinkEmitter = null;
        private final ICommonsList<AbstractMarkdownPlugin> m_aPlugins = new CommonsArrayList();

        @Nonnull
        public Builder extendedProfile(boolean bl) {
            this.m_bForceExtendedProfile = bl;
            return this;
        }

        @Nonnull
        public Builder convertNewline2Br() {
            this.m_bConvertNewline2Br = true;
            return this;
        }

        @Nonnull
        public Builder safeMode(boolean bl) {
            this.m_bSafeMode = bl;
            return this;
        }

        @Nonnull
        public Builder encoding(@Nonnull Charset charset) {
            this.m_aEncoding = (Charset)ValueEnforcer.notNull((Object)charset, (String)"Encoding");
            return this;
        }

        @Nonnull
        public IMarkdownDecorator decorator() {
            return this.m_aDecorator;
        }

        @Nonnull
        public Builder decorator(@Nonnull IMarkdownDecorator iMarkdownDecorator) {
            this.m_aDecorator = (IMarkdownDecorator)ValueEnforcer.notNull((Object)iMarkdownDecorator, (String)"Decorator");
            return this;
        }

        @Nonnull
        public Builder codeBlockEmitter(@Nullable IMarkdownBlockEmitter iMarkdownBlockEmitter) {
            this.m_aCodeBlockEmitter = iMarkdownBlockEmitter;
            return this;
        }

        @Nonnull
        public Builder specialLinkEmitter(@Nullable IMarkdownSpanEmitter iMarkdownSpanEmitter) {
            this.m_aSpecialLinkEmitter = iMarkdownSpanEmitter;
            return this;
        }

        @Nonnull
        public Builder registerPlugins(AbstractMarkdownPlugin ... abstractMarkdownPluginArray) {
            this.m_aPlugins.addAll((Object[])abstractMarkdownPluginArray);
            return this;
        }

        @Nonnull
        public MarkdownConfiguration build() {
            return new MarkdownConfiguration(this.m_bSafeMode, this.m_aEncoding, this.m_aDecorator, this.m_aCodeBlockEmitter, this.m_bForceExtendedProfile, this.m_bConvertNewline2Br, this.m_aSpecialLinkEmitter, (List<? extends AbstractMarkdownPlugin>)this.m_aPlugins);
        }
    }
}

