/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js.tostring;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.html.js.tostring.IJSToStringConverter;
import com.helger.html.js.tostring.JSType;
import com.helger.json.IJson;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;

@Immutable
public final class JsonToStringConverter
implements IJSToStringConverter,
Serializable {
    @Override
    @Nullable
    public String objectToJSString(@Nullable Object object, @Nonnull JSType jSType) {
        if (object != null && !(object instanceof IJson)) {
            throw new IllegalArgumentException("The passed object is not of type IJson but " + object.getClass().getName());
        }
        if (jSType != JSType.JSON) {
            throw new IllegalArgumentException("Unexpected JSType '" + String.valueOf(jSType) + "'! Only JSON is supported!");
        }
        return object == null ? null : ((IJson)object).getAsJsonString();
    }

    public boolean equals(Object object) {
        return object instanceof JsonToStringConverter;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

