/*
 * Decompiled with CFR 0.152.
 */
package com.helger.html.js;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.array.ArrayHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringHex;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class JSMarshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSMarshaller.class);
    private static final char[] CHARS_TO_MASK = new char[]{'\"', '\'', '\\', '/', '\t', '\r', '\n', '\f'};
    private static final char[] CHARS_TO_MASK_REGEX = new char[]{'\\', '^', '$', '*', '+', '?', '|', '.', '-', '[', ']', '(', ')', '{', '}'};
    private static final char MASK_CHAR = '\\';
    private static final char MASK_CHAR_REGEX = '\\';
    private static final ICommonsSet<String> RESERVED_KEYWORDS = new CommonsHashSet((Object[])new String[]{"break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "enum", "export", "extends", "import", "super", "true", "false", "null", "undefined"});

    private JSMarshaller() {
    }

    @Nullable
    public static String javaScriptEscape(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return string;
        }
        char[] cArray = string.toCharArray();
        if (!StringHelper.containsAny((char[])cArray, (char[])CHARS_TO_MASK)) {
            return string;
        }
        char[] cArray2 = new char[cArray.length * 2];
        int n = 0;
        int n2 = 0;
        for (int n3 : cArray) {
            switch (n3) {
                case 34: 
                case 39: 
                case 47: 
                case 92: {
                    cArray2[n++] = 92;
                    cArray2[n++] = n3;
                    break;
                }
                case 9: {
                    cArray2[n++] = 92;
                    cArray2[n++] = 116;
                    break;
                }
                case 10: {
                    if (n2 == 13) break;
                    cArray2[n++] = 92;
                    cArray2[n++] = 110;
                    break;
                }
                case 13: {
                    cArray2[n++] = 92;
                    cArray2[n++] = 110;
                    break;
                }
                case 12: {
                    cArray2[n++] = 92;
                    cArray2[n++] = 102;
                    break;
                }
                default: {
                    cArray2[n++] = n3;
                }
            }
            n2 = n3;
        }
        return new String(cArray2, 0, n);
    }

    @Nonnull
    public static String javaScriptEscapeForRegEx(char c) {
        if (ArrayHelper.contains((char[])CHARS_TO_MASK_REGEX, (char)c)) {
            return new StringBuilder(2).append('\\').append(c).toString();
        }
        return Character.toString(c);
    }

    @Nullable
    public static String javaScriptEscapeForRegEx(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return string;
        }
        char[] cArray = string.toCharArray();
        if (!StringHelper.containsAny((char[])cArray, (char[])CHARS_TO_MASK_REGEX)) {
            return string;
        }
        char[] cArray2 = new char[cArray.length * 2];
        int n = 0;
        for (char c : cArray) {
            if (ArrayHelper.contains((char[])CHARS_TO_MASK_REGEX, (char)c)) {
                cArray2[n++] = 92;
                cArray2[n++] = c;
                continue;
            }
            cArray2[n++] = c;
        }
        return new String(cArray2, 0, n);
    }

    @Nullable
    public static String javaScriptUnescape(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return string;
        }
        char[] cArray = string.toCharArray();
        if (!ArrayHelper.contains((char[])cArray, (char)'\\')) {
            return string;
        }
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int n3 = cArray[i];
            if (n2 == 92) {
                switch (n3) {
                    case 34: 
                    case 39: 
                    case 47: 
                    case 92: {
                        cArray2[n++] = n3;
                        break;
                    }
                    case 116: {
                        cArray2[n++] = 9;
                        break;
                    }
                    case 110: {
                        cArray2[n++] = 10;
                        break;
                    }
                    case 102: {
                        cArray2[n++] = 12;
                        break;
                    }
                    case 120: {
                        char c;
                        int n4;
                        if (i + 2 >= cArray.length) {
                            LOGGER.warn("Failed to unescape '" + string + "' - EOF in hex values");
                            return string;
                        }
                        ++i;
                        char c2 = cArray[i];
                        if ((n4 = StringHex.getHexByte((char)c2, (char)(c = cArray[++i]))) < 0) {
                            LOGGER.warn("Failed to unescape '" + string + "' - invalid hex values");
                            return string;
                        }
                        cArray2[n++] = (char)n4;
                        break;
                    }
                    default: {
                        cArray2[n++] = 92;
                        cArray2[n++] = n3;
                    }
                }
                n2 = 0;
                continue;
            }
            if (n3 != 92) {
                cArray2[n++] = n3;
            }
            n2 = n3;
        }
        if (n2 == 92) {
            cArray2[n++] = 92;
        }
        return new String(cArray2, 0, n);
    }

    public static boolean isJSIdentifier(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        if (RESERVED_KEYWORDS.contains((Object)string)) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (!(i == 0 ? !Character.isJavaIdentifierStart(cArray[i]) : !Character.isJavaIdentifierPart(cArray[i]))) continue;
            return false;
        }
        return true;
    }
}

